/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.threadedupdates;

import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkProviderClient.class})
public abstract class ChunkProviderClientMixin {
    @Unique
    private volatile long ft$writeCount;
    @Unique
    private Thread ft$clientThread;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void initMutex(World p_i1184_1_, CallbackInfo ci) {
        this.ft$writeCount = 0L;
        this.ft$clientThread = Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"unloadChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/LongHashMap;remove(J)Ljava/lang/Object;"), require=1)
    private Object threadSafeUnload(LongHashMap instance, long id) {
        ++this.ft$writeCount;
        try {
            Object object = instance.func_76159_d(id);
            return object;
        }
        finally {
            ++this.ft$writeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"loadChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/LongHashMap;add(JLjava/lang/Object;)V"), require=1)
    private void threadSafeLoad(LongHashMap instance, long id, Object value) {
        ++this.ft$writeCount;
        try {
            instance.func_76163_a(id, value);
        }
        finally {
            ++this.ft$writeCount;
        }
    }

    @Redirect(method={"provideChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/LongHashMap;getValueByKey(J)Ljava/lang/Object;"), require=1)
    private Object threadSafeGet(LongHashMap instance, long id) {
        long expectedWriteCount;
        boolean retry;
        Thread t = Thread.currentThread();
        if (this.ft$clientThread == t) {
            return instance.func_76164_a(id);
        }
        Object result = null;
        do {
            retry = false;
            do {
                expectedWriteCount = this.ft$writeCount;
            } while (this.ft$writeCount % 2L != 0L);
            try {
                result = instance.func_76164_a(id);
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                retry = true;
            }
        } while (retry || this.ft$writeCount != expectedWriteCount);
        return result;
    }
}

