/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.natives;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;

public class Unpacker {
    private final URL data;

    public Unpacker(URL data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] names() throws IOException {
        InputStream in = this.data.openStream();
        try {
            String[] stringArray;
            block9: {
                DataInputStream dIn = new DataInputStream(in);
                try {
                    int count = dIn.readInt();
                    String[] result = new String[count];
                    for (int i = 0; i < count; ++i) {
                        String name;
                        int nameLength = dIn.readUnsignedByte();
                        byte[] nameBuf = new byte[nameLength];
                        dIn.readFully(nameBuf);
                        result[i] = name = new String(nameBuf);
                        int length = dIn.readInt();
                        dIn.skipBytes(length);
                    }
                    stringArray = result;
                    if (Collections.singletonList(dIn).get(0) == null) break block9;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(dIn).get(0) != null) {
                        dIn.close();
                    }
                    throw throwable;
                }
                dIn.close();
            }
            return stringArray;
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unpack(String blobName, Path into) throws IOException {
        InputStream in = this.data.openStream();
        try {
            DataInputStream dIn = new DataInputStream(in);
            try {
                int length;
                block16: {
                    int count = dIn.readInt();
                    int i = 0;
                    while (i < count) {
                        int nameLength = dIn.readUnsignedByte();
                        byte[] nameBuf = new byte[nameLength];
                        dIn.readFully(nameBuf);
                        String name = new String(nameBuf);
                        length = dIn.readInt();
                        if (!blobName.equals(name)) {
                            dIn.skipBytes(length);
                            ++i;
                            continue;
                        }
                        break block16;
                    }
                    throw new IOException("Blob " + blobName + " not found in pak file!");
                }
                BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(into, new OpenOption[0]));
                try {
                    this.copy(dIn, output, length);
                    return;
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(dIn).get(0) != null) {
                    dIn.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    private void copy(InputStream input, OutputStream output, int bytes) throws IOException {
        byte[] buf = new byte[Math.min(bytes, 4096)];
        while (bytes > 0) {
            int toRead = Math.min(buf.length, bytes);
            int read = input.read(buf, 0, toRead);
            if (read < 0) {
                throw new EOFException();
            }
            output.write(buf, 0, read);
            bytes -= read;
        }
    }
}

