/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer.strategy;

import com.falsepattern.falsetweaks.modules.voxelizer.Face;
import com.falsepattern.falsetweaks.modules.voxelizer.strategy.MergingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class ExpandingRectMergingStrategy
implements MergingStrategy {
    public static final ExpandingRectMergingStrategy NoFlipNoInvRD;
    public static final ExpandingRectMergingStrategy NoFlipYesInvRD;
    public static final ExpandingRectMergingStrategy YesFlipNoInvRD;
    public static final ExpandingRectMergingStrategy YesFlipYesInvRD;
    public static final ExpandingRectMergingStrategy NoFlipNoInvRU;
    public static final ExpandingRectMergingStrategy NoFlipYesInvRU;
    public static final ExpandingRectMergingStrategy YesFlipNoInvRU;
    public static final ExpandingRectMergingStrategy YesFlipYesInvRU;
    public static final ExpandingRectMergingStrategy NoFlipNoInvLD;
    public static final ExpandingRectMergingStrategy NoFlipYesInvLD;
    public static final ExpandingRectMergingStrategy YesFlipNoInvLD;
    public static final ExpandingRectMergingStrategy YesFlipYesInvLD;
    public static final ExpandingRectMergingStrategy NoFlipNoInvLU;
    public static final ExpandingRectMergingStrategy NoFlipYesInvLU;
    public static final ExpandingRectMergingStrategy YesFlipNoInvLU;
    public static final ExpandingRectMergingStrategy YesFlipYesInvLU;
    private final Expander horizontalExpander;
    private final Expander verticalExpander;
    private final boolean flipIteration;
    private final boolean inverseExpansion;

    public static List<ExpandingRectMergingStrategy> all() {
        return Arrays.asList(NoFlipNoInvRD, NoFlipYesInvRD, YesFlipNoInvRD, YesFlipYesInvRD, NoFlipNoInvRU, NoFlipYesInvRU, YesFlipNoInvRU, YesFlipYesInvRU, NoFlipNoInvLD, NoFlipYesInvLD, YesFlipNoInvLD, YesFlipYesInvLD, NoFlipNoInvLU, NoFlipYesInvLU, YesFlipNoInvLU, YesFlipYesInvLU);
    }

    private static boolean tryExpandRight(Face[][] faces, Face root) {
        ArrayList<Face> candidates = new ArrayList<Face>();
        for (int y = root.minY; y <= root.maxY; ++y) {
            Face candidate = faces[y][root.maxX + 1];
            if (ExpandingRectMergingStrategy.isIneligible(candidate)) {
                return false;
            }
            candidates.add(candidate);
        }
        if (candidates.size() == 0) {
            return false;
        }
        ExpandingRectMergingStrategy.mergeAll(candidates);
        Face.tryMerge(root, candidates.get(0));
        return true;
    }

    private static boolean tryExpandDown(Face[][] faces, Face root) {
        ArrayList<Face> candidates = new ArrayList<Face>();
        for (int x = root.minX; x <= root.maxX; ++x) {
            Face candidate = faces[root.maxY + 1][x];
            if (ExpandingRectMergingStrategy.isIneligible(candidate)) {
                return false;
            }
            candidates.add(candidate);
        }
        if (candidates.size() == 0) {
            return false;
        }
        ExpandingRectMergingStrategy.mergeAll(candidates);
        Face.tryMerge(root, candidates.get(0));
        return true;
    }

    private static boolean tryExpandLeft(Face[][] faces, Face root) {
        ArrayList<Face> candidates = new ArrayList<Face>();
        for (int y = root.minY; y <= root.maxY; ++y) {
            Face candidate = faces[y][root.minX - 1];
            if (ExpandingRectMergingStrategy.isIneligible(candidate)) {
                return false;
            }
            candidates.add(candidate);
        }
        if (candidates.size() == 0) {
            return false;
        }
        ExpandingRectMergingStrategy.mergeAll(candidates);
        Face.tryMerge(root, candidates.get(0));
        return true;
    }

    private static boolean tryExpandUp(Face[][] faces, Face root) {
        ArrayList<Face> candidates = new ArrayList<Face>();
        for (int x = root.minX; x <= root.maxX; ++x) {
            Face candidate = faces[root.minY - 1][x];
            if (ExpandingRectMergingStrategy.isIneligible(candidate)) {
                return false;
            }
            candidates.add(candidate);
        }
        if (candidates.size() == 0) {
            return false;
        }
        ExpandingRectMergingStrategy.mergeAll(candidates);
        Face.tryMerge(root, candidates.get(0));
        return true;
    }

    private static void mergeAll(List<Face> candidates) {
        if (candidates.size() <= 1) {
            return;
        }
        Face root = candidates.get(0);
        for (Face candidate : candidates.subList(1, candidates.size())) {
            Face.tryMerge(root, candidate);
        }
    }

    private static boolean isIneligible(Face face) {
        return face == null || face.parent != null;
    }

    @Override
    public void merge(Face[][] faces) {
        if (this.flipIteration) {
            int x = this.horizontalExpander.startIndex(faces);
            while (this.horizontalExpander.shouldContinue(faces, x)) {
                int y = this.verticalExpander.startIndex(faces);
                while (this.verticalExpander.shouldContinue(faces, y)) {
                    this.tryExpand(faces, x, y);
                    y = this.verticalExpander.modifyValue(y);
                }
                x = this.horizontalExpander.modifyValue(x);
            }
        } else {
            int y = this.verticalExpander.startIndex(faces);
            while (this.verticalExpander.shouldContinue(faces, y)) {
                int x = this.horizontalExpander.startIndex(faces);
                while (this.horizontalExpander.shouldContinue(faces, x)) {
                    this.tryExpand(faces, x, y);
                    x = this.horizontalExpander.modifyValue(x);
                }
                y = this.verticalExpander.modifyValue(y);
            }
        }
    }

    private void tryExpand(Face[][] faces, int x, int y) {
        boolean expanded;
        Face root = faces[y][x];
        if (root == null || root.parent != null) {
            return;
        }
        do {
            if (this.inverseExpansion) {
                expanded = this.verticalExpander.expand(faces, root);
                expanded |= this.horizontalExpander.expand(faces, root);
                continue;
            }
            expanded = this.horizontalExpander.expand(faces, root);
            expanded |= this.verticalExpander.expand(faces, root);
        } while (expanded);
    }

    @Generated
    private static ExpandingRectMergingStrategyBuilder builder() {
        return new ExpandingRectMergingStrategyBuilder();
    }

    @Generated
    private ExpandingRectMergingStrategy(Expander horizontalExpander, Expander verticalExpander, boolean flipIteration, boolean inverseExpansion) {
        this.horizontalExpander = horizontalExpander;
        this.verticalExpander = verticalExpander;
        this.flipIteration = flipIteration;
        this.inverseExpansion = inverseExpansion;
    }

    static {
        Expander expandRight = new Expander(){

            @Override
            public boolean expand(Face[][] faces, Face root) {
                return root.maxX < faces[0].length - 1 && ExpandingRectMergingStrategy.tryExpandRight(faces, root);
            }

            @Override
            public int startIndex(Face[][] faces) {
                return 0;
            }

            @Override
            public boolean shouldContinue(Face[][] faces, int index) {
                return index < faces[0].length;
            }

            @Override
            public int modifyValue(int index) {
                return index + 1;
            }
        };
        Expander expandDown = new Expander(){

            @Override
            public boolean expand(Face[][] faces, Face root) {
                return root.maxY < faces.length - 1 && ExpandingRectMergingStrategy.tryExpandDown(faces, root);
            }

            @Override
            public int startIndex(Face[][] faces) {
                return 0;
            }

            @Override
            public boolean shouldContinue(Face[][] faces, int index) {
                return index < faces.length;
            }

            @Override
            public int modifyValue(int index) {
                return index + 1;
            }
        };
        Expander expandLeft = new Expander(){

            @Override
            public boolean expand(Face[][] faces, Face root) {
                return root.minX > 0 && ExpandingRectMergingStrategy.tryExpandLeft(faces, root);
            }

            @Override
            public int startIndex(Face[][] faces) {
                return faces[0].length - 1;
            }

            @Override
            public boolean shouldContinue(Face[][] faces, int index) {
                return index >= 0;
            }

            @Override
            public int modifyValue(int index) {
                return index - 1;
            }
        };
        Expander expandUp = new Expander(){

            @Override
            public boolean expand(Face[][] faces, Face root) {
                return root.minY > 0 && ExpandingRectMergingStrategy.tryExpandUp(faces, root);
            }

            @Override
            public int startIndex(Face[][] faces) {
                return faces.length - 1;
            }

            @Override
            public boolean shouldContinue(Face[][] faces, int index) {
                return index >= 0;
            }

            @Override
            public int modifyValue(int index) {
                return index - 1;
            }
        };
        ExpandingRectMergingStrategyBuilder builder = ExpandingRectMergingStrategy.builder();
        builder.inverseExpansion(false).horizontalExpander(expandRight).verticalExpander(expandDown);
        NoFlipNoInvRD = builder.flipIteration(false).build();
        NoFlipYesInvRD = builder.inverseExpansion(true).build();
        YesFlipYesInvRD = builder.flipIteration(true).build();
        YesFlipNoInvRD = builder.inverseExpansion(false).build();
        builder.verticalExpander(expandUp);
        NoFlipNoInvRU = builder.flipIteration(false).build();
        NoFlipYesInvRU = builder.inverseExpansion(true).build();
        YesFlipYesInvRU = builder.flipIteration(true).build();
        YesFlipNoInvRU = builder.inverseExpansion(false).build();
        builder.horizontalExpander(expandLeft);
        builder.verticalExpander(expandDown);
        NoFlipNoInvLD = builder.flipIteration(false).build();
        NoFlipYesInvLD = builder.inverseExpansion(true).build();
        YesFlipYesInvLD = builder.flipIteration(true).build();
        YesFlipNoInvLD = builder.inverseExpansion(false).build();
        builder.verticalExpander(expandUp);
        NoFlipNoInvLU = builder.flipIteration(false).build();
        NoFlipYesInvLU = builder.inverseExpansion(true).build();
        YesFlipYesInvLU = builder.flipIteration(true).build();
        YesFlipNoInvLU = builder.inverseExpansion(false).build();
    }

    @Generated
    private static class ExpandingRectMergingStrategyBuilder {
        @Generated
        private Expander horizontalExpander;
        @Generated
        private Expander verticalExpander;
        @Generated
        private boolean flipIteration;
        @Generated
        private boolean inverseExpansion;

        @Generated
        ExpandingRectMergingStrategyBuilder() {
        }

        @Generated
        private ExpandingRectMergingStrategyBuilder horizontalExpander(Expander horizontalExpander) {
            this.horizontalExpander = horizontalExpander;
            return this;
        }

        @Generated
        private ExpandingRectMergingStrategyBuilder verticalExpander(Expander verticalExpander) {
            this.verticalExpander = verticalExpander;
            return this;
        }

        @Generated
        private ExpandingRectMergingStrategyBuilder flipIteration(boolean flipIteration) {
            this.flipIteration = flipIteration;
            return this;
        }

        @Generated
        private ExpandingRectMergingStrategyBuilder inverseExpansion(boolean inverseExpansion) {
            this.inverseExpansion = inverseExpansion;
            return this;
        }

        @Generated
        private ExpandingRectMergingStrategy build() {
            return new ExpandingRectMergingStrategy(this.horizontalExpander, this.verticalExpander, this.flipIteration, this.inverseExpansion);
        }

        @Generated
        public String toString() {
            return "ExpandingRectMergingStrategy.ExpandingRectMergingStrategyBuilder(horizontalExpander=" + this.horizontalExpander + ", verticalExpander=" + this.verticalExpander + ", flipIteration=" + this.flipIteration + ", inverseExpansion=" + this.inverseExpansion + ")";
        }
    }

    private static interface Expander {
        public boolean expand(Face[][] var1, Face var2);

        public int startIndex(Face[][] var1);

        public boolean shouldContinue(Face[][] var1, int var2);

        public int modifyValue(int var1);
    }
}

