/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates.block;

import com.falsepattern.falsetweaks.asm.modules.threadedupdates.block.Threading_BlockMinMax;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Threading_BlockMinMaxRedirector
implements TurboClassTransformer {
    private static final List<String> VanillaBlockExclusions = Arrays.asList("net/minecraft/block/IGrowable", "net/minecraft/block/ITileEntityProvider", "net/minecraft/block/BlockEventData", "net/minecraft/block/BlockSourceImpl", "net/minecraft/block/material/");
    private static final Set<String> moddedBlockSubclasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> blockOwnerExclusions = Collections.newSetFromMap(new ConcurrentHashMap());

    private boolean isVanillaBlockSubclass(String className) {
        if ("aji".equals(className)) {
            return true;
        }
        if (!className.startsWith(Threading_BlockMinMax.packageInternal)) {
            return false;
        }
        for (String exclusion : VanillaBlockExclusions) {
            if (!className.startsWith(exclusion)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlockSubclass(String className) {
        return this.isVanillaBlockSubclass(className) || moddedBlockSubclasses.contains(className);
    }

    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "Threading_BlockMinMaxRedirector";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return true;
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        if (!this.isVanillaBlockSubclass(cn.name) && this.isBlockSubclass(cn.superName)) {
            moddedBlockSubclasses.add(cn.name);
        }
        if (moddedBlockSubclasses.contains(cn.name)) {
            boolean doWeShadow = false;
            doWeShadow = blockOwnerExclusions.contains(cn.superName) ? true : cn.fields.stream().anyMatch(Threading_BlockMinMax::shouldRemoveField);
            if (doWeShadow) {
                blockOwnerExclusions.add(cn.name);
            }
        }
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            ListIterator insnList = mn.instructions.iterator();
            while (insnList.hasNext()) {
                String fieldToRedirect;
                int opcode;
                AbstractInsnNode node = (AbstractInsnNode)insnList.next();
                if (!(node instanceof FieldInsnNode) || (opcode = node.getOpcode()) != 180 && opcode != 181) continue;
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (!"D".equals(fNode.desc) || !this.isBlockSubclass(fNode.owner) || blockOwnerExclusions.contains(fNode.owner) || (fieldToRedirect = Threading_BlockMinMax.tryMapFieldNameToMCP(fNode.name)) == null) continue;
                MethodInsnNode replacementMethod = new MethodInsnNode(182, "net/minecraft/block/Block", "ft$" + fieldToRedirect, opcode == 180 ? "()D" : "(D)V", false);
                insnList.set(replacementMethod);
                changed = true;
            }
        }
        return changed;
    }
}

