/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.cc;

import com.falsepattern.falsetweaks.api.dynlights.DynamicLightsDriver;
import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.falsetweaks.modules.dynlights.ArrayCache;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;

public class ChunkCacheFT
extends ChunkCache {
    private static final ArrayCache<int[]> cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache<Block[]> cacheBlocks = new ArrayCache(Block.class, 16);
    private static final int ARRAY_SIZE = 8000;
    private final int posX;
    private final int posY;
    private final int posZ;
    private int[] combinedLights;
    private Block[] blocks;

    public ChunkCacheFT(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, int subIn) {
        super(world, xMin, yMin, zMin, xMax, yMax, zMax, subIn);
        this.posX = xMin - subIn;
        this.posY = yMin - subIn;
        this.posZ = zMin - subIn;
    }

    public int func_72802_i(int x, int y, int z, int lightValue) {
        if (this.combinedLights == null) {
            return this.getLightBrightnessForSkyBlocksRaw(x, y, z, lightValue);
        }
        int index = this.getPositionIndex(x, y, z);
        if (index >= 0 && index < this.combinedLights.length) {
            int light = this.combinedLights[index];
            if (light == -1) {
                this.combinedLights[index] = light = this.getLightBrightnessForSkyBlocksRaw(x, y, z, lightValue);
            }
            return light;
        }
        return this.getLightBrightnessForSkyBlocksRaw(x, y, z, lightValue);
    }

    private int getLightBrightnessForSkyBlocksRaw(int x, int y, int z, int lightValue) {
        int light = super.func_72802_i(x, y, z, lightValue);
        DynamicLightsDriver dl = FTDynamicLights.frontend();
        if (dl.enabled() && !this.func_147439_a(x, y, z).func_149662_c()) {
            light = dl.getCombinedLight(x, y, z, light);
        }
        return light;
    }

    public Block func_147439_a(int x, int y, int z) {
        if (this.blocks == null) {
            return super.func_147439_a(x, y, z);
        }
        int index = this.getPositionIndex(x, y, z);
        if (index >= 0 && index < this.blocks.length) {
            Block block = this.blocks[index];
            if (block == null) {
                this.blocks[index] = block = super.func_147439_a(x, y, z);
            }
            return block;
        }
        return super.func_147439_a(x, y, z);
    }

    private int getPositionIndex(int x, int y, int z) {
        int i = x - this.posX;
        int j = y - this.posY;
        int k = z - this.posZ;
        return i >= 0 && j >= 0 && k >= 0 && i < 20 && j < 20 && k < 20 ? i * 400 + k * 20 + j : -1;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = cacheCombinedLights.allocate(8000);
        }
        Arrays.fill(this.combinedLights, -1);
        if (this.blocks == null) {
            this.blocks = cacheBlocks.allocate(8000);
        }
        Arrays.fill(this.blocks, null);
    }

    public void renderFinish() {
        cacheCombinedLights.free(this.combinedLights);
        this.combinedLights = null;
        cacheBlocks.free(this.blocks);
        this.blocks = null;
    }
}

