/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer.strategy;

import com.falsepattern.falsetweaks.modules.voxelizer.Face;
import com.falsepattern.falsetweaks.modules.voxelizer.strategy.MergingStrategy;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class RowColumnMergingStrategy
implements MergingStrategy {
    public static final RowColumnMergingStrategy NoFlip = new RowColumnMergingStrategy(false);
    public static final RowColumnMergingStrategy YesFlip = new RowColumnMergingStrategy(true);
    private final boolean flipIteration;

    public static List<RowColumnMergingStrategy> all() {
        return Arrays.asList(NoFlip, YesFlip);
    }

    @Override
    public void merge(Face[][] faces) {
        if (this.flipIteration) {
            this.vertical(faces);
            this.horizontal(faces);
        } else {
            this.horizontal(faces);
            this.vertical(faces);
        }
    }

    private void horizontal(Face[][] faces) {
        for (Face[] row : faces) {
            this.mergeSide(row);
        }
    }

    private void vertical(Face[][] faces) {
        for (int y = 0; y < faces.length - 1; ++y) {
            Face[] rowA = faces[y];
            Face[] rowB = faces[y + 1];
            for (int x = 0; x < rowA.length; ++x) {
                Face.tryMerge(rowA[x], rowB[x]);
            }
        }
    }

    @Generated
    private RowColumnMergingStrategy(boolean flipIteration) {
        this.flipIteration = flipIteration;
    }
}

