/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;

@Config.Comment(value={"Miscellaneous renderer tweaks"})
@Config(modid="falsetweaks", category="triangulator")
@Config.LangKey
public class TriangulatorConfig {
    @Config.Comment(value={"Used to toggle the namesake feature of this mod: quad triangulation.", "If you turn this off, the triangulation will not execute, but you will still have the AO and the", "smooth lighting fixes.", "Triangulation fixes an issue with incorrectly-aligned quads causing a minor visual bug, however,", "on weaker systems, it may noticeably decrease render performance (integrated graphics).", "By sacrificing a bit of visual quality, you might get back a few extra FPS depending on your system.", "FPS impact: System-dependent. Intel iGPUs struggle when this is enabled."})
    @Config.LangKey
    @Config.Name(value="quadTriangulation", migrations={""})
    @Config.DefaultBoolean(value=false)
    public static boolean ENABLE_QUAD_TRIANGULATION;
    @Config.Comment(value={"Disable the calibration chat prompt"})
    @Config.LangKey
    @Config.Name(value="hideCalibrationPrompt", migrations={""})
    @Config.DefaultBoolean(value=false)
    public static boolean SUPPRESS_CALIBRATION;

    public static void init() {
    }

    static {
        ConfigurationManager.selfInit();
    }

    @Config(modid="falsetweaks", customPath="falsetweaks_userspecific", category="calibration")
    public static class Calibration {
        @Config.Comment(value={"Modifies the way ambient occlusion alignment is calculated. Used for compatibility purposes,\nbecause different graphics cards have different ways of processing quads.\nThis is useful when quad triangulation is disabled for compatibility reasons."})
        @Config.DefaultBoolean(value=false)
        public static boolean FLIP_DIAGONALS;
        @Config.Comment(value={"The SHA256 hash of the graphics card that this calibration was configured for."})
        @Config.DefaultString(value="undefined")
        public static String GPU_HASH;

        static {
            ConfigurationManager.selfInit();
        }
    }
}

