/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.triangulator;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.api.triangulator.ToggleableTessellator;
import com.falsepattern.falsetweaks.modules.triangulator.ToggleableTessellatorManager;
import com.falsepattern.falsetweaks.modules.triangulator.interfaces.ITriangulatorTessellator;
import com.falsepattern.falsetweaks.modules.vertexapi.VertexInfo;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.client.renderer.Tessellator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Tessellator.class})
public abstract class TessellatorMixin
implements ITriangulatorTessellator,
ToggleableTessellator {
    @Shadow
    @Final
    public static Tessellator field_78398_a;
    @Shadow
    private int field_78409_u;
    @Shadow
    private int[] field_78405_h;
    @Shadow
    private int field_147569_p;
    @Shadow
    private int field_78406_i;
    private boolean hackedQuadRendering = false;
    private boolean drawingTris = false;
    private boolean alternativeTriangulation = false;
    private boolean quadTriangulationTemporarilySuspended = false;
    private Compat.ShaderType shaderOn = Compat.ShaderType.None;
    private int forceQuadRendering = 0;
    private int quadVerticesPutIntoBuffer = 0;

    @Inject(method={"reset"}, at={@At(value="HEAD")}, require=1)
    private void resetState(CallbackInfo ci) {
        this.drawingTris = false;
        this.hackedQuadRendering = false;
        this.quadTriangulationTemporarilySuspended = false;
        this.alternativeTriangulation = false;
        this.quadVerticesPutIntoBuffer = 0;
    }

    @Redirect(method={"startDrawing"}, at=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/renderer/Tessellator;drawMode:I"), require=1)
    private void forceDrawingTris(Tessellator instance, int value) {
        if (!this.isTriangulatorDisabled() && value == 7) {
            this.hackedQuadRendering = true;
            value = 4;
        } else {
            this.hackedQuadRendering = false;
        }
        if (value == 4) {
            this.drawingTris = true;
        }
        this.field_78409_u = value;
    }

    @Override
    public boolean hackedQuadRendering() {
        return this.hackedQuadRendering;
    }

    @Override
    public boolean quadTriangulationActive() {
        return !this.quadTriangulationTemporarilySuspended;
    }

    @Override
    public void suspendQuadTriangulation() {
        this.quadTriangulationTemporarilySuspended = true;
        if (this.quadVerticesPutIntoBuffer != 0) {
            Share.log.error((Object)new RuntimeException("Someone suspended triangulation while the tessellator had a partially rendered quad! Stacktrace: "));
            this.quadVerticesPutIntoBuffer = 0;
        }
    }

    @Override
    public void triangulate() {
        if (this.hackedQuadRendering) {
            this.fixAOTriangles();
        } else if (this.field_78409_u == 7) {
            this.fixAOQuad();
        }
    }

    private void ensureRawBufferHasExtraSpaceFor(int numberOfInts) {
        int newIndex = this.field_147569_p + numberOfInts;
        if (newIndex >= this.ft$rawBufferSize()) {
            if (this.ft$rawBufferSize() < 65536) {
                this.ft$rawBufferSize(65536);
            }
            while (newIndex >= this.ft$rawBufferSize()) {
                this.ft$rawBufferSize(this.ft$rawBufferSize() * 2);
            }
            this.field_78405_h = Arrays.copyOf(this.field_78405_h, this.ft$rawBufferSize());
        }
    }

    private void fixAOTriangles() {
        if (this.quadTriangulationTemporarilySuspended) {
            return;
        }
        ++this.quadVerticesPutIntoBuffer;
        if (this.quadVerticesPutIntoBuffer == 4) {
            int vertexSize = VertexInfo.getVertexInfo(this.shaderOn(), 1);
            this.ensureRawBufferHasExtraSpaceFor(2 * vertexSize);
            this.quadVerticesPutIntoBuffer = 0;
            if (this.alternativeTriangulation) {
                System.arraycopy(this.field_78405_h, this.field_147569_p - 3 * vertexSize, this.field_78405_h, this.field_147569_p, 2 * vertexSize);
                System.arraycopy(this.field_78405_h, this.field_147569_p - vertexSize, this.field_78405_h, this.field_147569_p - 2 * vertexSize, vertexSize);
                this.alternativeTriangulation = false;
            } else {
                System.arraycopy(this.field_78405_h, this.field_147569_p - 4 * vertexSize, this.field_78405_h, this.field_147569_p, vertexSize);
                System.arraycopy(this.field_78405_h, this.field_147569_p - 2 * vertexSize, this.field_78405_h, this.field_147569_p + vertexSize, vertexSize);
            }
            this.field_78406_i += 2;
            this.field_147569_p += 2 * vertexSize;
        }
    }

    private void fixAOQuad() {
        if (this.alternativeTriangulation) {
            ++this.quadVerticesPutIntoBuffer;
            if (this.quadVerticesPutIntoBuffer == 4) {
                int vertexSize = VertexInfo.getVertexInfo(this.shaderOn(), 1);
                this.ensureRawBufferHasExtraSpaceFor(vertexSize * 2);
                System.arraycopy(this.field_78405_h, this.field_147569_p - 4 * vertexSize, this.field_78405_h, this.field_147569_p, vertexSize);
                System.arraycopy(this.field_78405_h, this.field_147569_p - 3 * vertexSize, this.field_78405_h, this.field_147569_p - 4 * vertexSize, 3 * vertexSize);
                System.arraycopy(this.field_78405_h, this.field_147569_p, this.field_78405_h, this.field_147569_p - vertexSize, vertexSize);
                this.quadVerticesPutIntoBuffer = 0;
                this.alternativeTriangulation = false;
            }
        } else {
            this.quadVerticesPutIntoBuffer = 0;
        }
    }

    @Override
    public void resumeQuadTriangulation() {
        this.quadTriangulationTemporarilySuspended = false;
    }

    @Override
    public boolean isQuadTriangulationSuspended() {
        return this.quadTriangulationTemporarilySuspended;
    }

    @Override
    public void disableTriangulator() {
        ToggleableTessellatorManager.INSTANCE.disableTriangulator();
    }

    @Override
    public void enableTriangulator() {
        ToggleableTessellatorManager.INSTANCE.enableTriangulator();
    }

    @Override
    public void disableTriangulatorLocal() {
        ++this.forceQuadRendering;
    }

    @Override
    public void enableTriangulatorLocal() {
        --this.forceQuadRendering;
        if (this.forceQuadRendering < 0) {
            this.forceQuadRendering = 0;
        }
    }

    @Override
    public boolean isTriangulatorDisabled() {
        return ToggleableTessellatorManager.INSTANCE.isTriangulatorDisabled() || this.forceQuadRendering != 0;
    }

    @Override
    public Compat.ShaderType shaderOn() {
        return this.shaderOn;
    }

    @Override
    public void shaderOn(Compat.ShaderType state) {
        this.shaderOn = state;
    }

    @Override
    @Generated
    public boolean drawingTris() {
        return this.drawingTris;
    }

    @Override
    @Generated
    public boolean alternativeTriangulation() {
        return this.alternativeTriangulation;
    }

    @Override
    @Generated
    public void alternativeTriangulation(boolean alternativeTriangulation) {
        this.alternativeTriangulation = alternativeTriangulation;
    }
}

