/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.modules.bsp.sorting.PolygonHolder;
import com.falsepattern.falsetweaks.modules.bsp.sorting.SharedMath;
import com.falsepattern.falsetweaks.modules.bsp.sorting.TreeNode;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.joml.Math;
import org.joml.Vector3f;

public class ChunkBSPTree {
    private static final ThreadLocal<Scratch> SCRATCH = ThreadLocal.withInitial(() -> new Scratch());
    public final PolygonHolder polygonHolder;
    public final TIntArrayList polygonList = new TIntArrayList();
    private final List<TreeNode> nodes = new ArrayList<TreeNode>();
    private int root = -1;

    public ChunkBSPTree(boolean triangleMode, Compat.ShaderType shaderType) {
        this.polygonHolder = new PolygonHolder(triangleMode, shaderType);
    }

    private static int findSplitCandidate(TIntList list, int start, int length, PolygonHolder holder, Vector3f scratchBuffer) {
        float centerX = 0.0f;
        float centerY = 0.0f;
        float centerZ = 0.0f;
        for (int j = 0; j < length; ++j) {
            int i = list.get(start + j);
            holder.midpoint(i, scratchBuffer);
            centerX += scratchBuffer.x;
            centerY += scratchBuffer.y;
            centerZ += scratchBuffer.z;
        }
        centerX /= (float)length;
        centerY /= (float)length;
        centerZ /= (float)length;
        int candidatePolygon = list.get(start);
        float candidateArea = holder.area(candidatePolygon, scratchBuffer);
        holder.midpoint(candidatePolygon, scratchBuffer);
        float candidateMidpointX = scratchBuffer.x;
        float candidateMidpointY = scratchBuffer.y;
        float candidateMidpointZ = scratchBuffer.z;
        for (int j = 1; j < length; ++j) {
            int polygon = list.get(start + j);
            float polygonArea = holder.area(polygon, scratchBuffer);
            holder.midpoint(polygon, scratchBuffer);
            float polygonMidpointX = scratchBuffer.x;
            float polygonMidpointY = scratchBuffer.y;
            float polygonMidpointZ = scratchBuffer.z;
            if (!(polygonArea > candidateArea) && (polygonArea != candidateArea || !(SharedMath.distanceSquared(polygonMidpointX, polygonMidpointY, polygonMidpointZ, centerX, centerY, centerZ) < SharedMath.distanceSquared(candidateMidpointX, candidateMidpointY, candidateMidpointZ, centerX, centerY, centerZ)))) continue;
            candidatePolygon = polygon;
            candidateArea = polygonArea;
            candidateMidpointX = polygonMidpointX;
            candidateMidpointY = polygonMidpointY;
            candidateMidpointZ = polygonMidpointZ;
        }
        return candidatePolygon;
    }

    public void buildTree(int[] vertexData) {
        this.polygonHolder.setVertexData(vertexData);
        this.nodes.clear();
        int polygonCount = this.polygonHolder.getPolygonCount();
        TIntArrayList indexes = new TIntArrayList(polygonCount);
        for (int i = 0; i < polygonCount; ++i) {
            indexes.add(i);
        }
        if (!indexes.isEmpty()) {
            Scratch scratch = SCRATCH.get();
            this.root = this.buildTree(1.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 4.0f, indexes, 0, indexes.size(), scratch.nodeList, scratch.frontList, scratch.backList, 0, scratch.scratchBuffer);
        } else {
            this.root = -1;
        }
    }

    public void traverse(Vector3f viewpoint) {
        this.polygonList.resetQuick();
        this.traverse(this.root, viewpoint, (TIntList)this.polygonList);
    }

    private int buildTree(float normalX, float normalY, float normalZ, float originX, float originY, float originZ, float delta, TIntArrayList list, int start, int length, TIntArrayList nodeList, TIntArrayList frontList, TIntArrayList backList, int depth, Vector3f scratchBuffer) {
        int candidate;
        float nextDelta;
        float nextOriginZ;
        float nextOriginY;
        float nextOriginX;
        float nextNormalZ;
        float nextNormalY;
        float nextNormalX;
        if (length == 0) {
            return -1;
        }
        if (length == 1 || (double)delta < 0.001) {
            this.nodes.add(new TreeNode(normalX, normalY, normalZ, originX, originY, originZ, (TIntList)list, start, length, -1, -1));
            return this.nodes.size() - 1;
        }
        for (int j = 0; j < length; ++j) {
            int i = list.get(j + start);
            this.polygonHolder.midpoint(i, scratchBuffer);
            float midpointX = scratchBuffer.x;
            float midpointY = scratchBuffer.y;
            float midpointZ = scratchBuffer.z;
            float factor = SharedMath.dot(normalX, normalY, normalZ, midpointX - originX, midpointY - originY, midpointZ - originZ);
            if (factor == 0.0f) {
                nodeList.add(i);
                continue;
            }
            if (factor > 0.0f) {
                frontList.add(i);
                continue;
            }
            backList.add(i);
        }
        int nodeStart = start;
        int nodeLength = nodeList.size();
        for (int i = 0; i < nodeLength; ++i) {
            list.setQuick(nodeStart + i, nodeList.getQuick(i));
        }
        nodeList.resetQuick();
        int frontStart = nodeStart + nodeLength;
        int frontLength = frontList.size();
        for (int i = 0; i < frontLength; ++i) {
            list.setQuick(frontStart + i, frontList.getQuick(i));
        }
        frontList.resetQuick();
        int backStart = frontStart + frontLength;
        int backLength = backList.size();
        for (int i = 0; i < backLength; ++i) {
            list.setQuick(backStart + i, backList.getQuick(i));
        }
        backList.resetQuick();
        float candidateNormalX = normalZ;
        float candidateNormalY = normalX;
        float candidateNormalZ = normalY;
        float candidateDelta = delta;
        if (depth % 3 == 2) {
            candidateDelta /= 2.0f;
        }
        int frontIndex = -1;
        int backIndex = -1;
        if (frontLength != 0) {
            nextNormalX = candidateNormalX;
            nextNormalY = candidateNormalY;
            nextNormalZ = candidateNormalZ;
            nextOriginX = Math.fma((float)delta, (float)normalX, (float)originX);
            nextOriginY = Math.fma((float)delta, (float)normalY, (float)originY);
            nextOriginZ = Math.fma((float)delta, (float)normalZ, (float)originZ);
            nextDelta = candidateDelta;
            if (nextDelta < 5.0f) {
                candidate = ChunkBSPTree.findSplitCandidate((TIntList)list, frontStart, frontLength, this.polygonHolder, scratchBuffer);
                this.polygonHolder.normal(candidate, scratchBuffer);
                nextNormalX = scratchBuffer.x;
                nextNormalY = scratchBuffer.y;
                nextNormalZ = scratchBuffer.z;
                this.polygonHolder.midpoint(candidate, scratchBuffer);
                nextOriginX = scratchBuffer.x;
                nextOriginY = scratchBuffer.y;
                nextOriginZ = scratchBuffer.z;
            }
            frontIndex = this.buildTree(nextNormalX, nextNormalY, nextNormalZ, nextOriginX, nextOriginY, nextOriginZ, nextDelta, list, frontStart, frontLength, nodeList, frontList, backList, depth + 1, scratchBuffer);
            if (backLength == 0 && nodeLength == 0) {
                return frontIndex;
            }
        }
        if (backLength != 0) {
            nextNormalX = candidateNormalX;
            nextNormalY = candidateNormalY;
            nextNormalZ = candidateNormalZ;
            nextOriginX = Math.fma((float)(-delta), (float)normalX, (float)originX);
            nextOriginY = Math.fma((float)(-delta), (float)normalY, (float)originY);
            nextOriginZ = Math.fma((float)(-delta), (float)normalZ, (float)originZ);
            nextDelta = candidateDelta;
            if (nextDelta < 5.0f) {
                candidate = ChunkBSPTree.findSplitCandidate((TIntList)list, backStart, backLength, this.polygonHolder, scratchBuffer);
                this.polygonHolder.normal(candidate, scratchBuffer);
                nextNormalX = scratchBuffer.x;
                nextNormalY = scratchBuffer.y;
                nextNormalZ = scratchBuffer.z;
                this.polygonHolder.midpoint(candidate, scratchBuffer);
                nextOriginX = scratchBuffer.x;
                nextOriginY = scratchBuffer.y;
                nextOriginZ = scratchBuffer.z;
            }
            backIndex = this.buildTree(nextNormalX, nextNormalY, nextNormalZ, nextOriginX, nextOriginY, nextOriginZ, nextDelta, list, backStart, backLength, nodeList, frontList, backList, depth + 1, scratchBuffer);
            if (frontLength == 0 && nodeLength == 0) {
                return backIndex;
            }
        }
        this.nodes.add(new TreeNode(normalX, normalY, normalZ, originX, originY, originZ, (TIntList)list, nodeStart, nodeLength, frontIndex, backIndex));
        return this.nodes.size() - 1;
    }

    private void traverse(int node, Vector3f viewpoint, TIntList output) {
        if (node < 0) {
            return;
        }
        TreeNode n = this.nodes.get(node);
        float factor = SharedMath.dot(n.normalX, n.normalY, n.normalZ, viewpoint.x - n.originX, viewpoint.y - n.originY, viewpoint.z - n.originZ);
        if (factor > 0.0f) {
            this.traverse(n.backRef, viewpoint, output);
        } else {
            this.traverse(n.frontRef, viewpoint, output);
        }
        if (factor != 0.0f) {
            for (int j = 0; j < n.length; ++j) {
                output.add(n.triangleRefsList.get(j + n.start));
            }
        }
        if (factor > 0.0f) {
            this.traverse(n.frontRef, viewpoint, output);
        } else {
            this.traverse(n.backRef, viewpoint, output);
        }
    }

    private static class Scratch {
        public final TIntArrayList nodeList = new TIntArrayList();
        public final TIntArrayList frontList = new TIntArrayList();
        public final TIntArrayList backList = new TIntArrayList();
        public final Vector3f scratchBuffer = new Vector3f();

        private Scratch() {
        }
    }
}

