/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting;

import org.joml.Math;
import org.joml.Vector3f;

public class SharedMath {
    public static float getTriArea(float ax, float ay, float az, float cx, float cy, float cz, float dx, float dy, float dz, Vector3f buf) {
        float triArea;
        if (ax == cx && ay == cy && az == cz || cx == dx && cy == dy && cz == dz || ax == dx && ay == dy && az == dz) {
            triArea = 0.0f;
        } else {
            SharedMath.getTriangleNormalUnscaled(ax, ay, az, cx, cy, cz, dx, dy, dz, buf);
            triArea = SharedMath.unscaledNormalToArea(buf);
        }
        return triArea;
    }

    public static float unscaledNormalToArea(Vector3f normal) {
        return normal.lengthSquared() / 4.0f;
    }

    public static void getMidpoint(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Vector3f output) {
        output.set((minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f);
    }

    public static void getTriangleNormalUnscaled(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, Vector3f output) {
        output.set(bx - ax, by - ay, bz - az).cross(cx - ax, cy - ay, cz - az);
    }

    public static float distanceSquared(float x1, float y1, float z1, float x2, float y2, float z2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        float dz = z1 - z2;
        return Math.fma((float)dx, (float)dx, (float)Math.fma((float)dy, (float)dy, (float)(dz * dz)));
    }

    public static float dot(float x1, float y1, float z1, float x2, float y2, float z2) {
        return Math.fma((float)x1, (float)x2, (float)Math.fma((float)y1, (float)y2, (float)(z1 * z2)));
    }
}

