/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting.area;

import com.falsepattern.falsetweaks.modules.bsp.sorting.SharedMath;
import com.falsepattern.falsetweaks.modules.bsp.sorting.area.NormalAreaComputer;
import org.joml.Vector3f;

public class TriangleAreaComputer
implements NormalAreaComputer {
    public static final TriangleAreaComputer INSTANCE = new TriangleAreaComputer();

    @Override
    public float getArea(int[] vertexData, int i, int vertexSize, Vector3f buf) {
        this.getNormalUnscaled(vertexData, i, vertexSize, buf);
        return SharedMath.unscaledNormalToArea(buf);
    }

    @Override
    public void getNormal(int[] vertexData, int i, int vertexSize, Vector3f output) {
        this.getNormalUnscaled(vertexData, i, vertexSize, output);
        output.normalize();
    }

    private void getNormalUnscaled(int[] vertexData, int i, int vertexSize, Vector3f output) {
        float ax = Float.intBitsToFloat(vertexData[i]);
        float ay = Float.intBitsToFloat(vertexData[i + 1]);
        float az = Float.intBitsToFloat(vertexData[i + 2]);
        float bx = Float.intBitsToFloat(vertexData[i + vertexSize]);
        float by = Float.intBitsToFloat(vertexData[i + vertexSize + 1]);
        float bz = Float.intBitsToFloat(vertexData[i + vertexSize + 2]);
        float cx = Float.intBitsToFloat(vertexData[i + vertexSize * 2]);
        float cy = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 1]);
        float cz = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 2]);
        SharedMath.getTriangleNormalUnscaled(ax, ay, az, bx, by, bz, cx, cy, cz, output);
    }
}

