/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint;

import com.falsepattern.falsetweaks.modules.bsp.sorting.SharedMath;
import com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint.MidpointComputer;
import org.joml.Vector3f;

public class QuadMidpointComputer
implements MidpointComputer {
    public static final QuadMidpointComputer INSTANCE = new QuadMidpointComputer();

    @Override
    public void getMidpoint(int[] vertexData, int i, int vertexSize, Vector3f output) {
        float ax = Float.intBitsToFloat(vertexData[i]);
        float ay = Float.intBitsToFloat(vertexData[i + 1]);
        float az = Float.intBitsToFloat(vertexData[i + 2]);
        float bx = Float.intBitsToFloat(vertexData[i + vertexSize]);
        float by = Float.intBitsToFloat(vertexData[i + vertexSize + 1]);
        float bz = Float.intBitsToFloat(vertexData[i + vertexSize + 2]);
        float cx = Float.intBitsToFloat(vertexData[i + vertexSize * 2]);
        float cy = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 1]);
        float cz = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 2]);
        float dx = Float.intBitsToFloat(vertexData[i + vertexSize * 3]);
        float dy = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 1]);
        float dz = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 2]);
        float minX = Math.min(Math.min(ax, bx), Math.min(cx, dx));
        float minY = Math.min(Math.min(ay, by), Math.min(cy, dy));
        float minZ = Math.min(Math.min(az, bz), Math.min(cz, dz));
        float maxX = Math.max(Math.max(ax, bx), Math.max(cx, dx));
        float maxY = Math.max(Math.max(ay, by), Math.max(cy, dy));
        float maxZ = Math.max(Math.max(az, bz), Math.max(cz, dz));
        SharedMath.getMidpoint(minX, minY, minZ, maxX, maxY, maxZ, output);
    }
}

