/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.debug;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.modules.debug.Debug;
import java.awt.FlowLayout;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class Toggler
extends JFrame {
    public Toggler() {
        this.setTitle("FalseTweaks Debug Menu");
        this.setLayout(new FlowLayout());
        if (ModuleConfig.THREADED_CHUNK_UPDATES()) {
            this.createToggle("Occlusion", Debug.occlusionChecks, x -> {
                Debug.occlusionChecks = x;
            });
            this.createToggle("Occlusion Mask (SEIZURE WARNING)", Debug.occlusionMask, x -> {
                Debug.occlusionMask = x;
            });
            this.createToggle("Frustum", Debug.frustumChecks, x -> {
                Debug.frustumChecks = x;
            });
            if (Compat.optiFineHasShaders()) {
                this.createToggle("Shadow Pass", Debug.shadowPass, x -> {
                    Debug.shadowPass = x;
                });
                this.createToggle("Shadow Occlusion", Debug.shadowOcclusionChecks, x -> {
                    Debug.shadowOcclusionChecks = x;
                });
                this.createToggle("Shadow Occlusion Mask (SEIZURE WARNING)", Debug.shadowOcclusionMask, x -> {
                    Debug.shadowOcclusionMask = x;
                });
            }
            this.createToggle("Chunk Baking", Debug.chunkRebaking, x -> {
                Debug.chunkRebaking = x;
            });
            this.createToggle("Translucency sorting", Debug.translucencySorting, x -> {
                Debug.translucencySorting = x;
            });
            this.createToggle("TESR Rendering (Chests, stolen!)", Debug.tesrRendering, x -> {
                Debug.tesrRendering = x;
            });
            this.createToggle("Java Fine Logging", Debug.fineLogJava, x -> {
                Debug.fineLogJava = x;
            });
            this.createToggle("Java Trace Logging", Debug.fineLogJavaTrace, x -> {
                Debug.fineLogJavaTrace = x;
            });
            this.createToggle("MEGATrace Fine Logging", Debug.fineLogMegaTrace, x -> {
                Debug.fineLogMegaTrace = x;
            });
        }
        this.setSize(300, 200);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createToggle(String name, boolean defaultState, Consumer<Boolean> onUpdate) {
        JCheckBox box = new JCheckBox(name);
        box.setSelected(defaultState);
        box.addItemListener(e -> onUpdate.accept(e.getStateChange() == 1));
        this.add(box);
    }
}

