/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.dynlights.base;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.modules.dynlights.DynamicLightsDrivers;
import com.falsepattern.falsetweaks.modules.dynlights.base.DynamicLights;
import com.falsepattern.lib.util.MathUtil;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;

public class DynamicLight {
    private final Entity entity;
    private final double offsetY;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;

    public DynamicLight(Entity entity) {
        this.entity = entity;
        this.offsetY = entity.func_70047_e();
    }

    public void update(RenderGlobal renderGlobal) {
        boolean isHandLight;
        boolean bl = isHandLight = this.entity == Minecraft.func_71410_x().field_71451_h && Compat.shaderType() != Compat.ShaderType.Optifine;
        if (!isHandLight && DynamicLightsDrivers.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.field_70165_t - 0.5;
        double posY = this.entity.field_70163_u - 0.5 + this.offsetY;
        double posZ = this.entity.field_70161_v - 0.5;
        int lightLevel = DynamicLights.INSTANCE.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (!(Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel)) {
            this.underwater = false;
            WorldClient world = renderGlobal.field_72769_h;
            if (world != null) {
                Block block = world.func_147439_a(MathUtil.floor((double)posX), MathUtil.floor((double)posY), MathUtil.floor((double)posZ));
                boolean bl2 = this.underwater = block == Blocks.field_150355_j;
            }
            if (lightLevel > 0) {
                int distance = lightLevel + 1;
                renderGlobal.func_147585_a((int)(posX - (double)distance), (int)(posY - (double)distance), (int)(posZ - (double)distance), (int)(posX + (double)distance), (int)(posY + (double)distance), (int)(posZ + (double)distance));
            }
            this.updateLitChunks(renderGlobal);
            this.lastPosX = posX;
            this.lastPosY = posY;
            this.lastPosZ = posZ;
            this.lastLightLevel = lightLevel;
        }
    }

    public void updateLitChunks(RenderGlobal renderGlobal) {
        int distance = this.lastLightLevel + 1;
        renderGlobal.func_147585_a((int)(this.lastPosX - (double)distance), (int)(this.lastPosY - (double)distance), (int)(this.lastPosZ - (double)distance), (int)(this.lastPosX + (double)distance), (int)(this.lastPosY + (double)distance), (int)(this.lastPosZ + (double)distance));
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }

    @Generated
    public Entity getEntity() {
        return this.entity;
    }

    @Generated
    public double getOffsetY() {
        return this.offsetY;
    }

    @Generated
    public double getLastPosX() {
        return this.lastPosX;
    }

    @Generated
    public double getLastPosY() {
        return this.lastPosY;
    }

    @Generated
    public double getLastPosZ() {
        return this.lastPosZ;
    }

    @Generated
    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    @Generated
    public boolean isUnderwater() {
        return this.underwater;
    }
}

