/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

public enum VoxelType {
    Solid,
    SemiSolid,
    Transparent;


    public static VoxelType[] renderable() {
        return new VoxelType[]{Solid, SemiSolid};
    }

    public static VoxelType fromNumber(int number) {
        switch (number) {
            case 0: {
                return Transparent;
            }
            case 1: {
                return SemiSolid;
            }
            case 2: {
                return Solid;
            }
        }
        throw new IllegalArgumentException(Integer.toString(number));
    }

    public static VoxelType fromAlpha(int alpha) {
        switch (alpha) {
            case 0: {
                return Transparent;
            }
            case 255: {
                return Solid;
            }
        }
        return SemiSolid;
    }

    public int toNumber() {
        switch (this) {
            case Transparent: {
                return 0;
            }
            case SemiSolid: {
                return 1;
            }
            case Solid: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }
}

