/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;
import lombok.Generated;

@Config.Comment(value={"Dynamic hand and entity lights"})
@Config(modid="falsetweaks", category="dynamic_lights", categoryMigrations={"dynamiclights"})
@Config.LangKey
public class DynamicLightsConfig {
    @Config.Comment(value={"Enable/disable dynamic lights without restarting the game"})
    @Config.LangKey
    @Config.Name(value="state", migrations={""})
    @Config.DefaultEnum(value="Fast")
    public static DynamicLightsState STATE;
    @Config.Comment(value={"Use this to determine if the player hand and/or dropped items/entities should emit light.", "Disabling entity light considerable improves performance with a lot of dropped items and mob farms."})
    @Config.LangKey
    @Config.Name(value="lightSources")
    @Config.DefaultEnum(value="HandAndEntity")
    public static LightSources LIGHT_SOURCES;
    @Config.Comment(value={"Set this to false if you want to make dynamic lights diamond-shaped, like block lights."})
    @Config.LangKey
    @Config.Name(value="circular", migrations={""})
    @Config.DefaultBoolean(value=true)
    public static boolean CIRCULAR;

    public static void init() {
    }

    static {
        ConfigurationManager.selfInit();
    }

    public static enum LightSources {
        HandOnly(true, false),
        EntityOnly(false, true),
        HandAndEntity(true, true);

        public final boolean hand;
        public final boolean entity;

        @Generated
        private LightSources(boolean hand, boolean entity) {
            this.hand = hand;
            this.entity = entity;
        }
    }

    public static enum DynamicLightsState {
        Fast,
        Fancy,
        Disabled;

    }
}

