/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;

@Config.Comment(value={"Multithreaded rendering settings. Also look at the occlusion category."})
@Config(modid="falsetweaks", category="threading")
@Config.LangKey
public class ThreadingConfig {
    @Config.Comment(value={"The number of threads to use for chunk building.", "1   - Recommended", "2-8 - For higher-end systems, with diminishing results"})
    @Config.LangKey
    @Config.Name(value="threads", migrations={""})
    @Config.DefaultInt(value=1)
    @Config.RangeInt(min=1, max=8)
    public static int CHUNK_UPDATE_THREADS;
    @Config.Comment(value={"Disable this to use a slower, but more accurate thread safety check in the tessellator."})
    @Config.LangKey
    @Config.Name(value="fastChecks", migrations={""})
    @Config.DefaultBoolean(value=true)
    public static boolean FAST_SAFETY_CHECKS;
    @Config.Comment(value={"Enables some extra debug info for error stacktraces.", "EXPENSIVE! Only turn this on for debugging purposes!", "FPS Impact: significant slowdown"})
    @Config.LangKey
    @Config.Name(value="extraDebugInfo", migrations={""})
    @Config.DefaultBoolean(value=false)
    public static boolean EXTRA_DEBUG_INFO;
    @Config.Comment(value={"Classes added here will be automatically patched to use the threaded Tessellator.", "FalseTweaks also includes an internal hardcoded list of patched classes.", "Use * at the end of a line for a wildcard match (useful for targeting whole packages!)", "This patch covers most edge cases, however some implementations will still require manual patches."})
    @Config.LangKey
    @Config.Name(value="tessellatorReplacementTargets", migrations={""})
    @Config.ListMaxLength(value=0x7FFFFFFF)
    @Config.StringMaxLength(value=65535)
    @Config.DefaultStringList(value={})
    @Config.RequiresMcRestart
    public static String[] TESSELLATOR_USE_REPLACEMENT_TARGETS;
    @Config.Comment(value={"Patches every class with the thread safe tessellator code. Overrides TESSELLATOR_USE_REPLACEMENT_TARGETS"})
    @Config.LangKey
    @Config.Name(value="tessellatorReplaceEverything", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean TESSELLATOR_REPLACE_EVERYTHING;
    @Config.Comment(value={"ISimpleBlockRenderingHandler classes added here will be treated as thread-safe.", "In many cases, these classes should also be included in TESSELLATOR_USE_REPLACEMENT_TARGETS.", "Syntax: classname:constructor", "Examples:", "Implicitly thread-safe (stateless):                                                 com.example.ExampleRenderer:safe", "Default constructor (aka: new ExampleRenderer()):                                   com.example.ExampleRenderer:default!", "Custom constructor supplied by a utility mod (creates a new instance every call):   com.example.ExampleRenderer:com.mymod.ThreadTools!createExampleRenderer", "Custom threadlocal managed by a utility mod (returns the same instance per thread): com.example.ExampleRenderer:com.mymod.ThreadTools?threadExampleRenderer", "All of these MUST be zero argument methods!"})
    @Config.LangKey
    @Config.Name(value="threadSafeBlockRenderers", migrations={""})
    @Config.DefaultStringList(value={})
    @Config.ListMaxLength(value=0x7FFFFFFF)
    @Config.StringMaxLength(value=65535)
    @Config.RequiresMcRestart
    public static String[] THREAD_SAFE_ISBRHS;
    @Config.Comment(value={"Disables the logging of block rendering handler registrations."})
    @Config.LangKey
    @Config.Name(value="logBlockRendererErrors", migrations={""})
    @Config.DefaultBoolean(value=true)
    public static boolean LOG_ISBRH_ERRORS;
    @Config.Comment(value={"Speeds up the threading of block bounds, try turning this off if you get compatibility issues."})
    @Config.LangKey
    @Config.Name(value="fastThreadedBlockBounds", migrations={""})
    @Config.DefaultBoolean(value=true)
    public static boolean FAST_THREADED_BLOCK_BOUNDS;

    public static void init() {
    }

    static {
        ConfigurationManager.selfInit();
    }
}

