/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.animfix;

import com.falsepattern.falsetweaks.api.animfix.IAnimationUpdateBatcher;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL11;

public class DefaultAnimationUpdateBatcher
implements IAnimationUpdateBatcher {
    private final int mipLevels;
    private final int xOffset;
    private final int yOffset;
    private final int width;
    private final int height;
    private final int[] offsets;
    private final IntBuffer memory;
    private final Semaphore batchingSemaphore = new Semaphore(0);
    private final Semaphore uploadingSemaphore = new Semaphore(0);
    private final Thread thread;
    private volatile Buffer backBuffer = new Buffer();
    private volatile boolean running = true;

    DefaultAnimationUpdateBatcher(int xOffset, int yOffset, int width, int height, int mipLevel) {
        this.mipLevels = mipLevel;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
        this.offsets = new int[mipLevel + 1];
        int size = 0;
        for (int i = 0; i <= mipLevel; ++i) {
            this.offsets[i] = size;
            size += (width >>> i) * (height >>> i);
        }
        this.memory = GLAllocation.func_74527_f((int)size);
        this.thread = new Thread(this::run);
        this.thread.setName("FalseTweaks texture batching thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public boolean scheduleUpload(int[][] texture, int width, int height, int xOffset, int yOffset) {
        if ((xOffset -= this.xOffset) < 0 || xOffset >= this.width || (yOffset -= this.yOffset) < 0 || yOffset >= this.height) {
            return false;
        }
        int i = this.backBuffer.queuedCount++;
        List<int[]> dimList = this.backBuffer.queuedDimensions;
        while (dimList.size() <= i) {
            dimList.add(new int[4]);
        }
        int[] dims = dimList.get(i);
        dims[0] = width;
        dims[1] = height;
        dims[2] = xOffset;
        dims[3] = yOffset;
        this.backBuffer.queuedTextures.add(texture);
        return true;
    }

    @Override
    public void terminate() {
        this.running = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void upload() {
        this.batchingSemaphore.release();
        while (!this.uploadingSemaphore.tryAcquire()) {
            Thread.yield();
        }
        for (int i = 0; i <= this.mipLevels; ++i) {
            this.memory.position(this.offsets[i]);
            GL11.glTexSubImage2D((int)3553, (int)i, (int)(this.xOffset >>> i), (int)(this.yOffset >>> i), (int)(this.width >>> i), (int)(this.height >>> i), (int)32993, (int)33639, (IntBuffer)this.memory);
        }
        this.batchingSemaphore.release();
        while (!this.uploadingSemaphore.tryAcquire()) {
            Thread.yield();
        }
    }

    private void run() {
        Buffer frontBuffer = new Buffer();
        Buffer backBuffer = this.backBuffer;
        while (this.running) {
            this.uploadingSemaphore.release();
            while (this.running) {
                try {
                    this.batchingSemaphore.acquire();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (!this.running) {
                return;
            }
            Buffer tmp2 = frontBuffer;
            frontBuffer = backBuffer;
            this.backBuffer = backBuffer = tmp2;
            this.uploadingSemaphore.release();
            while (this.running) {
                try {
                    this.batchingSemaphore.acquire();
                    break;
                }
                catch (InterruptedException tmp2) {
                }
            }
            if (!this.running) {
                return;
            }
            List<int[]> dfb = frontBuffer.queuedDimensions;
            List<int[][]> tfb = frontBuffer.queuedTextures;
            for (int i = frontBuffer.queuedCount - 1; i >= 0; --i) {
                this.batchUpload(dfb.get(i), tfb.remove(i));
            }
            frontBuffer.queuedCount = 0;
        }
    }

    private void batchUpload(int[] dims, int[][] texture) {
        int width = dims[0];
        int height = dims[1];
        int xOffset = dims[2];
        int yOffset = dims[3];
        int w = this.width;
        for (int mipMapLevel = 0; mipMapLevel < texture.length; ++mipMapLevel) {
            int base = this.offsets[mipMapLevel] + yOffset * w + xOffset;
            for (int i = 0; i < height; ++i) {
                this.memory.position(base + i * w);
                this.memory.put(texture[mipMapLevel], i * width, width);
            }
            xOffset >>>= 1;
            yOffset >>>= 1;
            width >>>= 1;
            height >>>= 1;
            w >>>= 1;
        }
    }

    private static class Buffer {
        public final List<int[][]> queuedTextures = new ArrayList<int[][]>();
        public final List<int[]> queuedDimensions = new ArrayList<int[]>();
        public int queuedCount = 0;

        private Buffer() {
        }
    }
}

