/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.threadedupdates.saftey;

import com.falsepattern.falsetweaks.api.threading.ThreadSafeBlockRenderer;
import com.falsepattern.falsetweaks.config.ThreadingConfig;
import com.google.common.base.Strings;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadSafeBlockRendererMap
implements Map<Integer, ISimpleBlockRenderingHandler> {
    private static final Map<String, List<ISBRHErrorMessage>> ERROR_MESSAGES = new HashMap<String, List<ISBRHErrorMessage>>();
    private static final AtomicInteger TOTAL_ERRORS = new AtomicInteger();
    private static boolean bypass = false;
    private final Map<Integer, ISimpleBlockRenderingHandler> wrappedMap = new HashMap<Integer, ISimpleBlockRenderingHandler>();

    private static ISimpleBlockRenderingHandler threadSafeWrap(ISimpleBlockRenderingHandler isbrh) {
        if (isbrh instanceof ThreadSafeBlockRenderer) {
            return ((ThreadSafeBlockRenderer)isbrh).forCurrentThread();
        }
        return isbrh;
    }

    public static void inject() {
        Field blockRenderers = RenderingRegistry.class.getDeclaredField("blockRenderers");
        blockRenderers.setAccessible(true);
        RenderingRegistry rr = RenderingRegistry.instance();
        Map oldRenderers = (Map)blockRenderers.get(rr);
        ThreadSafeBlockRendererMap newRenderers = new ThreadSafeBlockRendererMap();
        bypass = true;
        newRenderers.putAll(oldRenderers);
        bypass = false;
        blockRenderers.set(rr, newRenderers);
    }

    public static void logBrokenISBRHs() {
        if (!ThreadingConfig.LOG_ISBRH_ERRORS) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"FT|THREAD SAFETY");
        if (ERROR_MESSAGES.isEmpty()) {
            logger.info("No ISBRH errors found.");
            return;
        }
        int totalSources = ERROR_MESSAGES.size();
        int totalErrors = TOTAL_ERRORS.get();
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("Found: {} unsafe ISBRH{} from: {} source{}", new Object[]{totalErrors, totalErrors != 1 ? "s" : "", totalSources, totalSources != 1 ? "s" : ""});
        for (Map.Entry<String, List<ISBRHErrorMessage>> error : ERROR_MESSAGES.entrySet()) {
            String mod = error.getKey();
            List<ISBRHErrorMessage> messages = error.getValue();
            int messageCount = messages.size();
            logger.error(Strings.repeat((String)"=", (int)50));
            logger.error("  MOD: {} has: {} unsafe ISBRH{}", new Object[]{mod, messageCount, messageCount != 1 ? "s" : ""});
            for (ISBRHErrorMessage message : messages) {
                switch (message.kind) {
                    case Null: {
                        logger.error("    ID {} is null!", new Object[]{message.id});
                        break;
                    }
                    case NonThreadSafe: {
                        logger.error("    ID {} is not thread safe! ISBRH Class: {}", new Object[]{message.id, message.className});
                    }
                }
                logger.trace("", message.stacktrace);
            }
            logger.error(Strings.repeat((String)"=", (int)50));
        }
        logger.error("Open the log file to view detailed stacktraces.");
        logger.error(Strings.repeat((String)"+=", (int)25));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISimpleBlockRenderingHandler put(Integer key, ISimpleBlockRenderingHandler value) {
        if (ThreadingConfig.LOG_ISBRH_ERRORS) {
            Map<String, List<ISBRHErrorMessage>> map = ERROR_MESSAGES;
            synchronized (map) {
                if (value instanceof ThreadSafeBlockRenderer) {
                } else {
                    ModContainer activeModContainer;
                    String activeModID = bypass ? "UNKNOWN" : ((activeModContainer = Loader.instance().activeModContainer()) == null ? "UNKNOWN" : activeModContainer.getModId());
                    ERROR_MESSAGES.computeIfAbsent(activeModID, i -> new ArrayList()).add(new ISBRHErrorMessage(key, value == null ? "null" : value.getClass().getName(), value == null ? ISBRHErrorMessage.Kind.Null : ISBRHErrorMessage.Kind.NonThreadSafe, new Throwable()));
                    TOTAL_ERRORS.getAndIncrement();
                }
            }
        }
        return this.wrappedMap.put(key, value);
    }

    @Override
    public ISimpleBlockRenderingHandler remove(Object key) {
        return ThreadSafeBlockRendererMap.threadSafeWrap(this.wrappedMap.remove(key));
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends ISimpleBlockRenderingHandler> m) {
        for (Map.Entry<? extends Integer, ? extends ISimpleBlockRenderingHandler> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public Set<Integer> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<ISimpleBlockRenderingHandler> values() {
        return this.wrappedMap.values().stream().map(ThreadSafeBlockRendererMap::threadSafeWrap).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<Integer, ISimpleBlockRenderingHandler>> entrySet() {
        return this.wrappedMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ThreadSafeBlockRendererMap.threadSafeWrap((ISimpleBlockRenderingHandler)entry.getValue()))).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public ISimpleBlockRenderingHandler get(Object key) {
        return ThreadSafeBlockRendererMap.threadSafeWrap(this.wrappedMap.get(key));
    }

    private static class ISBRHErrorMessage {
        public final int id;
        public final String className;
        public final Kind kind;
        public final Throwable stacktrace;

        @Generated
        public ISBRHErrorMessage(int id, String className, Kind kind, Throwable stacktrace) {
            this.id = id;
            this.className = className;
            this.kind = kind;
            this.stacktrace = stacktrace;
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public Throwable getStacktrace() {
            return this.stacktrace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ISBRHErrorMessage)) {
                return false;
            }
            ISBRHErrorMessage other = (ISBRHErrorMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            Throwable this$stacktrace = this.getStacktrace();
            Throwable other$stacktrace = other.getStacktrace();
            return !(this$stacktrace == null ? other$stacktrace != null : !this$stacktrace.equals(other$stacktrace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ISBRHErrorMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            Throwable $stacktrace = this.getStacktrace();
            result = result * 59 + ($stacktrace == null ? 43 : $stacktrace.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ThreadSafeBlockRendererMap.ISBRHErrorMessage(id=" + this.getId() + ", className=" + this.getClassName() + ", kind=" + (Object)((Object)this.getKind()) + ", stacktrace=" + this.getStacktrace() + ")";
        }

        public static enum Kind {
            Null,
            NonThreadSafe;

        }
    }
}

