/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm;

import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.List;
import lombok.Generated;
import net.minecraft.launchwrapper.Launch;

public class ASMFixerUtility {
    public static void removeGTNHLibThreadingHook(Field f) {
        List transformers = (List)f.get(Launch.classLoader);
        transformers.removeIf(ASMFixerUtility::isForbidden);
        f.set(Launch.classLoader, new ThreadSafeTransformerFilterList(transformers));
    }

    private static boolean isForbidden(Object obj) {
        String n = obj.getClass().getName();
        return n.startsWith("com.gtnewhorizon.gtnhlib") && n.endsWith("TessellatorRedirectorTransformer");
    }

    private static class ThreadSafeTransformerFilterList<T>
    extends AbstractList<T> {
        private final List<T> real;

        @Override
        public T get(int index) {
            return this.real.get(index);
        }

        @Override
        public int size() {
            return this.real.size();
        }

        @Override
        public boolean add(T t) {
            if (ASMFixerUtility.isForbidden(t)) {
                return false;
            }
            return this.real.add(t);
        }

        @Override
        public T set(int index, T element) {
            if (ASMFixerUtility.isForbidden(element)) {
                return null;
            }
            return this.real.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            if (ASMFixerUtility.isForbidden(element)) {
                return;
            }
            this.real.add(index, element);
        }

        @Override
        public T remove(int index) {
            return this.real.remove(index);
        }

        @Generated
        public ThreadSafeTransformerFilterList(List<T> real) {
            this.real = real;
        }
    }
}

