/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates;

import com.falsepattern.falsetweaks.config.ThreadingConfig;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Threading_ThreadSafeBlockRendererInjector
implements TurboClassTransformer {
    public static final String THREAD_SAFE_ANNOTATION_InternalName = "com/falsepattern/falsetweaks/modules/threadedupdates/interop/ThreadSafeISBRH";
    public static final String THREAD_SAFE_ANNOTATION_DESC = "Lcom/falsepattern/falsetweaks/modules/threadedupdates/interop/ThreadSafeISBRH;";
    public static final String THREAD_SAFE_FACTORY_InternalName = "com/falsepattern/falsetweaks/modules/threadedupdates/interop/ThreadSafeISBRHFactory";
    public static final String FACTORY_METHOD_DESC = "()Lcom/falsepattern/falsetweaks/modules/threadedupdates/interop/ThreadSafeISBRHFactory;";
    public static final String FACTORY_METHOD_NAME = "newInstance";
    private static final Set<String> CLASS_NAMES = new HashSet<String>();
    private static final Set<String> INTERNAL_NAMES = new HashSet<String>();
    private static final Map<String, Handle> INITIALIZERS = new HashMap<String, Handle>();
    private static final Map<String, String> SUPPLIERS = new HashMap<String, String>();
    private static final Set<String> FACTORIES = new HashSet<String>();
    private static final String TSBR_InternalName = "com/falsepattern/falsetweaks/api/threading/ThreadSafeBlockRenderer";
    private static final String ISBR_InternalName = "cpw/mods/fml/client/registry/ISimpleBlockRenderingHandler";
    private static final Handle LAMBDA_META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;");
    private static final String[] HARDCODED = new String[]{"com.carpentersblocks.renderer.BlockHandlerCarpentersBarrier:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersBed:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersBlock:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersButton:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersCollapsibleBlock:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersDaylightSensor:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersDoor:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersFlowerPot:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersGarageDoor:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersGate:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersHatch:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersLadder:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersLever:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersPressurePlate:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersSafe:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersSlope:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersStairs:default!", "com.carpentersblocks.renderer.BlockHandlerCarpentersTorch:default!", "com.falsepattern.rple.api.client.render.LampRenderer:safe", "com.jaquadro.minecraft.storagedrawers.client.renderer.ControllerRenderer:default!", "com.jaquadro.minecraft.storagedrawers.client.renderer.DrawersCustomRenderer:default!", "com.jaquadro.minecraft.storagedrawers.client.renderer.DrawersRenderer:default!", "com.jaquadro.minecraft.storagedrawers.client.renderer.FramingTableRenderer:default!", "com.jaquadro.minecraft.storagedrawers.client.renderer.TrimCustomRenderer:default!", "net.minecraftforge.fluids.RenderBlockFluid:safe"};
    private static final Method createSupplier;

    public static void addAll(String ... entries) {
        for (String entry : entries) {
            String[] parts = entry.split(":");
            String className = parts[0];
            String internalName = className.replace('.', '/');
            CLASS_NAMES.add(className);
            INTERNAL_NAMES.add(internalName);
            String generator = parts[1];
            if ("safe".equals(generator)) continue;
            if (generator.contains("!")) {
                Handle creatorHandle;
                if ("default!".equals(generator)) {
                    creatorHandle = new Handle(8, internalName, "<init>", "()V");
                } else {
                    String[] genParts = generator.split("!");
                    String genInternalName = genParts[0].replace('.', '/');
                    String genMethodName = genParts[1];
                    creatorHandle = new Handle(6, genInternalName, genMethodName, "()L" + internalName + ";");
                }
                INITIALIZERS.put(internalName, creatorHandle);
                continue;
            }
            SUPPLIERS.put(internalName, generator);
        }
    }

    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "Threading_ThreadSafeBlockRendererInjector";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (CLASS_NAMES.contains(className)) {
            return true;
        }
        ClassNode node = classNode.getNode();
        if (node == null) {
            return false;
        }
        List anns = node.visibleAnnotations;
        if (anns == null) {
            return false;
        }
        String internalName = className.replace('.', '/');
        for (AnnotationNode ann : anns) {
            if (!THREAD_SAFE_ANNOTATION_DESC.equals(ann.desc)) continue;
            boolean perThread = false;
            List values = ann.values;
            if (values != null) {
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    Object name = iter.next();
                    Object value = iter.next();
                    if (!"perThread".equals(name)) continue;
                    perThread = (Boolean)value;
                }
            }
            if (perThread) {
                INITIALIZERS.put(internalName, new Handle(8, internalName, "<init>", "()V"));
            }
            return true;
        }
        List ifcs = node.interfaces;
        if (ifcs == null) {
            return false;
        }
        for (String ifc : ifcs) {
            if (!THREAD_SAFE_FACTORY_InternalName.equals(ifc)) continue;
            FACTORIES.add(className.replace('.', '/'));
            return true;
        }
        return false;
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        if (cn.interfaces.contains(TSBR_InternalName)) {
            return false;
        }
        String internalName = className.replace('.', '/');
        cn.interfaces.add(TSBR_InternalName);
        MethodNode getter = new MethodNode(1, "forCurrentThread", "()Lcpw/mods/fml/client/registry/ISimpleBlockRenderingHandler;", null, null);
        cn.methods.add(getter);
        InsnList insnList = getter.instructions;
        if (INITIALIZERS.containsKey(internalName)) {
            this.injectThreadLocal(cn, internalName, true);
            insnList.add((AbstractInsnNode)new FieldInsnNode(178, internalName, "ft$tlInjected", "Ljava/lang/ThreadLocal;"));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/ThreadLocal", "get", "()Ljava/lang/Object;", false));
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, ISBR_InternalName));
            getter.maxStack = 1;
        } else if (FACTORIES.contains(internalName)) {
            this.injectThreadLocal(cn, internalName, false);
            insnList.add((AbstractInsnNode)new FieldInsnNode(178, internalName, "ft$tlInjected", "Ljava/lang/ThreadLocal;"));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/ThreadLocal", "get", "()Ljava/lang/Object;", false));
            insnList.add((AbstractInsnNode)new InsnNode(89));
            LabelNode nonNull = new LabelNode();
            insnList.add((AbstractInsnNode)new JumpInsnNode(199, nonNull));
            insnList.add((AbstractInsnNode)new InsnNode(87));
            insnList.add((AbstractInsnNode)new FieldInsnNode(178, internalName, "ft$tlInjected", "Ljava/lang/ThreadLocal;"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, THREAD_SAFE_FACTORY_InternalName));
            insnList.add((AbstractInsnNode)new MethodInsnNode(185, THREAD_SAFE_FACTORY_InternalName, FACTORY_METHOD_NAME, FACTORY_METHOD_DESC, true));
            insnList.add((AbstractInsnNode)new InsnNode(90));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/ThreadLocal", "set", "(Ljava/lang/Object;)V", false));
            insnList.add((AbstractInsnNode)nonNull);
            insnList.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{"java/lang/Object"}));
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, ISBR_InternalName));
            getter.maxStack = 3;
        } else if (SUPPLIERS.containsKey(internalName)) {
            String supplier = SUPPLIERS.get(internalName);
            String[] parts = supplier.split("\\?");
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, parts[0], parts[1], "()L" + internalName + ";", false));
            getter.maxStack = 1;
        } else {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            getter.maxStack = 1;
        }
        insnList.add((AbstractInsnNode)new InsnNode(176));
        getter.maxLocals = 1;
        return true;
    }

    private void injectThreadLocal(ClassNode cn, String internalName, boolean withInitial) {
        if (withInitial) {
            cn.innerClasses.add(new InnerClassNode("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25));
        }
        cn.fields.add(new FieldNode(26, "ft$tlInjected", "Ljava/lang/ThreadLocal;", null, null));
        boolean staticInitializedFound = false;
        for (MethodNode method : cn.methods) {
            if (!"<clinit>".equals(method.name)) continue;
            staticInitializedFound = true;
            this.injectThreadLocalCreation(method, internalName, withInitial, cn.version);
        }
        if (!staticInitializedFound) {
            MethodNode clinit = new MethodNode(8, "<clinit>", "()V", null, null);
            clinit.instructions.add((AbstractInsnNode)new FrameNode(0, 0, new Object[0], 0, new Object[0]));
            cn.methods.add(clinit);
            this.injectThreadLocalCreation(clinit, internalName, withInitial, cn.version);
            clinit.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
    }

    private void injectThreadLocalCreation(MethodNode method, String internalName, boolean withInitial, int version) {
        ListIterator insnList = method.instructions.iterator();
        if (withInitial) {
            if (version >= 52) {
                insnList.add(new InvokeDynamicInsnNode("get", "()Ljava/util/function/Supplier;", LAMBDA_META_FACTORY, new Object[]{Type.getType((String)"()Ljava/lang/Object;"), INITIALIZERS.get(internalName), Type.getType((String)("()L" + internalName + ";"))}));
            } else {
                Handle initializer = INITIALIZERS.get(internalName);
                insnList.add(new LdcInsnNode((Object)initializer.getOwner()));
                insnList.add(new LdcInsnNode((Object)initializer.getName()));
                insnList.add(new LdcInsnNode((Object)initializer.getDesc()));
                insnList.add(new LdcInsnNode((Object)initializer.getTag()));
                insnList.add(new MethodInsnNode(184, Type.getInternalName(LegacyBytecodeSupplierFactory.class), createSupplier.getName(), createSupplier.getDescriptor(), false));
            }
            insnList.add(new MethodInsnNode(184, "java/lang/ThreadLocal", "withInitial", "(Ljava/util/function/Supplier;)Ljava/lang/ThreadLocal;", false));
        } else {
            insnList.add(new TypeInsnNode(187, "java/lang/ThreadLocal"));
            insnList.add(new InsnNode(89));
            insnList.add(new MethodInsnNode(183, "java/lang/ThreadLocal", "<init>", "()V", false));
        }
        insnList.add(new FieldInsnNode(179, internalName, "ft$tlInjected", "Ljava/lang/ThreadLocal;"));
        if (method.maxStack == 0) {
            method.maxStack = 1;
        }
    }

    static {
        Threading_ThreadSafeBlockRendererInjector.addAll(HARDCODED);
        Threading_ThreadSafeBlockRendererInjector.addAll(ThreadingConfig.THREAD_SAFE_ISBRHS);
        try {
            createSupplier = Method.getMethod((java.lang.reflect.Method)LegacyBytecodeSupplierFactory.class.getDeclaredMethod("createSupplier", String.class, String.class, String.class, Integer.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LegacyBytecodeSupplierFactory {
        public static Supplier<Object> createSupplier(String owner, String name, String desc, int tag) throws ClassNotFoundException {
            Class<?> klass = Class.forName(owner.replace('/', '.'));
            Type methodType = Type.getMethodType((String)desc);
            Type[] args = methodType.getArgumentTypes();
            if (tag == 6) {
                java.lang.reflect.Method[] methods;
                block0: for (java.lang.reflect.Method method : methods = klass.getDeclaredMethods()) {
                    Parameter[] params;
                    if (!Objects.equals(name, method.getName()) || (params = method.getParameters()).length != args.length || !Objects.equals(methodType.getReturnType(), Type.getType(method.getReturnType()))) continue;
                    for (int i = 0; i < params.length; ++i) {
                        if (!Objects.equals(args[i], Type.getType(params[i].getType()))) continue block0;
                    }
                    method.setAccessible(true);
                    return () -> {
                        try {
                            return method.invoke(null, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                throw new IllegalArgumentException("Could not find target method " + owner + ":" + name + ":" + desc);
            }
            if (tag == 8) {
                Constructor<?>[] constructors;
                block2: for (Constructor<?> method : constructors = klass.getDeclaredConstructors()) {
                    Parameter[] params = method.getParameters();
                    if (params.length != args.length) continue;
                    for (int i = 0; i < params.length; ++i) {
                        if (!Objects.equals(args[i], Type.getType(params[i].getType()))) continue block2;
                    }
                    method.setAccessible(true);
                    return () -> {
                        try {
                            return method.newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                throw new IllegalArgumentException("Could not find target constructor " + owner + ":" + name + ":" + desc);
            }
            throw new IllegalArgumentException("Unknown call tag: " + tag);
        }
    }
}

