/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.profiler;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.ProfilerConfig;
import com.falsepattern.falsetweaks.modules.profiler.ProfilingNode;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.minecraft.profiler.Profiler;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Profiler.class}, priority=0x7FFFFFFF)
public abstract class ProfilerMixin {
    @Shadow
    @Final
    private static Logger field_151234_b;
    @Shadow
    public boolean field_76327_a;
    private ProfilingNode origin;
    private ProfilingNode current;
    private List<ProfilingNode> history;
    private int ctr = 0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void init(CallbackInfo ci) {
        this.history = new ArrayList<ProfilingNode>();
    }

    @Overwrite
    public void func_76317_a() {
        if (ProfilerConfig.DUMP_ON_CLOSE) {
            this.dump();
        } else {
            this.history.clear();
            this.ctr = 0;
        }
        this.origin = this.current = ProfilingNode.createRoot();
    }

    @Overwrite
    public void func_76320_a(String section) {
        if (this.field_76327_a) {
            this.current = this.current.getOrCreateChild(section);
            this.current.start();
        } else if (ProfilerConfig.DUMP_ON_CLOSE) {
            this.dump();
        }
    }

    @Overwrite
    public void func_76319_b() {
        if (this.field_76327_a) {
            if (this.current.parent == null) {
                field_151234_b.warn("Tried to end a section without starting one!");
                return;
            }
            long delta = this.current.end();
            if (delta > 100000000L) {
                field_151234_b.warn("Something's taking too long! '" + this.current.fullName() + "' took approx " + (double)delta / 1000000.0 + " ms");
            }
            this.current = this.current.parent;
        }
    }

    @Overwrite
    public List<Profiler.Result> func_76321_b(String entry) {
        if (!this.field_76327_a) {
            return null;
        }
        this.beginNextSnapshot();
        String[] route = entry.split("\\.");
        List<ProfilingNode> nodes = this.history.stream().map(node -> node.findChild(route, 0)).filter(Objects::nonNull).collect(Collectors.toList());
        long rootTime = this.history.stream().mapToLong(node -> node.totalTime).sum();
        long nodeTime = nodes.stream().mapToLong(node -> node.totalTime).sum();
        HashMap<String, Long> childTimes = new HashMap<String, Long>();
        AtomicLong totalChildTime = new AtomicLong(0L);
        nodes.forEach(node -> node.childrenMap.forEach((childName, child) -> {
            childTimes.compute((String)childName, (k_, v) -> v == null ? child.totalTime : v + child.totalTime);
            totalChildTime.addAndGet(child.totalTime);
        }));
        ArrayList<Profiler.Result> result = new ArrayList<Profiler.Result>();
        float localPercentMultiplier = 100.0f / (float)nodeTime;
        float globalAverageMultiplier = 1.0f / (float)this.history.size();
        long unspecTime = nodeTime - totalChildTime.get();
        if (unspecTime > 0L) {
            result.add(new Profiler.Result("unspecified", (double)((float)unspecTime * localPercentMultiplier), (double)((float)unspecTime * globalAverageMultiplier)));
        }
        childTimes.forEach((key, value) -> result.add(new Profiler.Result(key, (double)((float)value.longValue() * localPercentMultiplier), (double)((float)value.longValue() * globalAverageMultiplier))));
        result.sort(null);
        result.add(0, new Profiler.Result(entry, 100.0, (double)((float)nodeTime * globalAverageMultiplier)));
        return result;
    }

    @Overwrite
    public String func_76322_c() {
        return this.current == null ? "[UNKNOWN]" : this.current.fullName();
    }

    private void dump() {
        if (this.history.size() > 0) {
            List<ProfilingNode> oldHistory = this.history;
            this.history = new ArrayList<ProfilingNode>();
            this.ctr = 0;
            Thread dump = new Thread(() -> {
                Path dumpFile;
                SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd'T'HH_mm_ss");
                StringBuilder filename = new StringBuilder(format.format(new Date()));
                try {
                    Files.createDirectory(Paths.get("ft_profiling_dumps", new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                do {
                    dumpFile = Paths.get("ft_profiling_dumps", filename + ".json");
                    filename.append("_");
                } while (Files.exists(dumpFile, new LinkOption[0]));
                try {
                    BufferedWriter stream = Files.newBufferedWriter(dumpFile, new OpenOption[0]);
                    try {
                        JsonWriter json = new JsonWriter((Writer)stream);
                        try {
                            long sumNanos = 0L;
                            for (ProfilingNode node : oldHistory) {
                                sumNanos += node.childrenMap.values().stream().mapToLong(elem -> elem.totalTime).sum();
                            }
                            json.setIndent("  ");
                            json.beginObject();
                            json.name("timeNs").value(sumNanos);
                            json.name("results");
                            json.beginArray();
                            for (ProfilingNode node : oldHistory) {
                                for (ProfilingNode child : node.childrenMap.values()) {
                                    child.toJson(json);
                                }
                            }
                            json.endArray();
                            json.endObject();
                        }
                        finally {
                            if (Collections.singletonList(json).get(0) != null) {
                                json.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(stream).get(0) != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    Share.log.warn("Failed to write False Tweaks profiling history to file", (Throwable)e);
                }
            });
            dump.setName("FTweaks Profiling Dump Thread");
            dump.start();
        }
    }

    private void beginNextSnapshot() {
        if (!ProfilerConfig.DUMP_ON_CLOSE && this.history.size() >= 1000) {
            this.history.set(this.ctr, this.origin);
            this.ctr = (this.ctr + 1) % 1000;
        } else {
            this.history.add(this.origin);
        }
        this.current = this.origin = ProfilingNode.createRoot();
    }
}

