/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.mipmapfix;

import com.falsepattern.falsetweaks.Share;
import cpw.mods.fml.common.ProgressManager;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;

public class MulticoreMipMapEngine {
    private static final ThreadLocal<MulticoreMipMapEngine> engine = new ThreadLocal();
    private final ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
        Thread thread = new Thread(r);
        thread.setName("MipMap");
        return thread;
    });
    private final ConcurrentLinkedDeque<String> completedTextures = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<ReportedException> exceptions = new ConcurrentLinkedDeque();
    private final ProgressManager.ProgressBar progressBar;

    private static IllegalStateException fatalError() {
        return new IllegalStateException("Multicore mipmap engine broken! Most likely an incompatibility with some other mod, PLEASE report this on the FalseTweaks github repo!");
    }

    public static void initWorkers(ProgressManager.ProgressBar bar) {
        if (engine.get() != null) {
            throw MulticoreMipMapEngine.fatalError();
        }
        engine.set(new MulticoreMipMapEngine(bar));
    }

    public static void scheduleToThreads(TextureAtlasSprite sprite, int mipMapLevels) {
        MulticoreMipMapEngine e = engine.get();
        if (e == null) {
            throw MulticoreMipMapEngine.fatalError();
        }
        e.scheduleToThreadsI(sprite, mipMapLevels);
    }

    public static void waitForWorkEnd() {
        MulticoreMipMapEngine e = engine.get();
        if (e == null) {
            throw MulticoreMipMapEngine.fatalError();
        }
        e.waitForWorkEndI();
        engine.set(null);
    }

    private void scheduleToThreadsI(TextureAtlasSprite sprite, int mipMapLevels) {
        this.service.execute(() -> {
            try {
                sprite.func_147963_d(mipMapLevels);
                this.completedTextures.add(sprite.func_94215_i());
            }
            catch (Throwable throwable1) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Applying mipmap");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
                crashreportcategory.func_71500_a("Sprite name", () -> ((TextureAtlasSprite)sprite).func_94215_i());
                crashreportcategory.func_71500_a("Sprite size", () -> sprite.func_94211_a() + " x " + sprite.func_94216_b());
                crashreportcategory.func_71500_a("Sprite frames", () -> sprite.func_110970_k() + " frames");
                crashreportcategory.func_71507_a("Mipmap levels", (Object)mipMapLevels);
                this.exceptions.add(new ReportedException(crashreport));
            }
        });
    }

    private void waitForWorkEndI() {
        this.service.shutdown();
        boolean terminated = false;
        ReportedException firstException = null;
        while (!terminated) {
            try {
                terminated = this.service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Share.log.trace((Object)e);
            }
            while (!this.completedTextures.isEmpty()) {
                String name = this.completedTextures.poll();
                if (name == null) continue;
                this.progressBar.step(name);
            }
            while (!this.exceptions.isEmpty()) {
                ReportedException ex = this.exceptions.poll();
                if (firstException == null) {
                    firstException = ex;
                }
                Share.log.error((Object)ex);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)this.progressBar);
        if (firstException != null) {
            throw firstException;
        }
    }

    @Generated
    private MulticoreMipMapEngine(ProgressManager.ProgressBar progressBar) {
        this.progressBar = progressBar;
    }
}

