/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.renderlists;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.RenderListConfig;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelMesh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import org.lwjgl.opengl.GL11;

public class VoxelRenderListManager
implements IResourceManagerReloadListener {
    public static final VoxelRenderListManager INSTANCE = new VoxelRenderListManager();
    private final Map<String, Integer> theMap = new HashMap<String, Integer>();
    private final List<String> identityList = new ArrayList<String>();
    private int list = 0;

    public boolean pre(VoxelMesh mesh, int overlayLayer, boolean remapUV) {
        String identity = mesh.getIdentity(overlayLayer, remapUV);
        if (this.theMap.containsKey(identity)) {
            Integer list = this.theMap.get(identity);
            this.identityList.add(this.identityList.remove(this.identityList.indexOf(identity)));
            GL11.glCallList((int)list);
            return true;
        }
        if (this.identityList.size() >= RenderListConfig.MAX_BUFFER_SIZE) {
            String oldIden = this.identityList.remove(0);
            GLAllocation.func_74523_b((int)this.theMap.remove(oldIden));
        }
        this.list = GLAllocation.func_74526_a((int)1);
        this.identityList.add(identity);
        this.theMap.put(identity, this.list);
        GL11.glNewList((int)this.list, (int)4864);
        return false;
    }

    public void post() {
        GL11.glEndList();
        GL11.glCallList((int)this.list);
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        Share.log.info("Resource pack reloaded! Clearing voxel render list cache.");
        this.identityList.clear();
        this.theMap.forEach((key, value) -> GLAllocation.func_74523_b((int)value));
        this.theMap.clear();
    }

    @Generated
    private VoxelRenderListManager() {
    }
}

