/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

import com.falsepattern.falsetweaks.modules.voxelizer.Dir;
import com.falsepattern.falsetweaks.modules.voxelizer.Face;
import com.falsepattern.falsetweaks.modules.voxelizer.Layer;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelGrid;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelType;
import com.falsepattern.falsetweaks.modules.voxelizer.interfaces.ITextureAtlasSpriteMixin;
import com.falsepattern.falsetweaks.modules.voxelizer.strategy.MergingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class VoxelCompiler {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    private final Layer[] layers;

    public VoxelCompiler(Layer ... layers) {
        this.layers = Arrays.copyOf(layers, layers.length);
        int x = 0;
        int y = 0;
        this.zSize = this.layers.length;
        for (int i = 0; i < this.zSize; ++i) {
            TextureAtlasSprite tex = layers[i].texture;
            int xTex = tex.func_94211_a();
            int yTex = tex.func_94216_b();
            if (((ITextureAtlasSpriteMixin)tex).useAnisotropicFiltering()) {
                xTex -= 16;
                yTex -= 16;
            }
            x = Math.max(x, xTex);
            y = Math.max(y, yTex);
        }
        this.xSize = x;
        this.ySize = y;
    }

    private static void unwrap(Face[][] faces, List<Face> result) {
        for (Face[] row : faces) {
            VoxelCompiler.unwrap(row, result);
        }
    }

    private static void unwrap(Face[] faces, List<Face> result) {
        for (Face f : faces) {
            if (f == null || f.parent != null || f.used) continue;
            result.add(f);
            f.used = true;
        }
    }

    public Map<VoxelType, List<Face>> compile(MergingStrategy strategy) {
        int x;
        int y;
        int z;
        VoxelGrid voxels = new VoxelGrid(this.xSize, this.ySize, this.zSize);
        for (z = 0; z < this.zSize; ++z) {
            for (y = 0; y < this.ySize; ++y) {
                for (x = 0; x < this.xSize; ++x) {
                    int alpha = this.layers[z].fetchAlpha(x, y, this.xSize, this.ySize);
                    voxels.setType(x, y, z, VoxelType.fromAlpha(alpha));
                }
            }
        }
        for (z = -1; z < this.zSize; ++z) {
            for (y = -1; y < this.ySize; ++y) {
                for (x = -1; x < this.xSize; ++x) {
                    int thisIndex = voxels.toIndex(x, y, z);
                    voxels.exchangeFaces(thisIndex, voxels.toIndex(x + 1, y, z), Dir.Right);
                    voxels.exchangeFaces(thisIndex, voxels.toIndex(x, y + 1, z), Dir.Down);
                    voxels.exchangeFaces(thisIndex, voxels.toIndex(x, y, z + 1), Dir.Front);
                }
            }
        }
        HashMap<VoxelType, List<Face>> finalResult = new HashMap<VoxelType, List<Face>>();
        Face[][] front = new Face[this.ySize][this.xSize];
        Face[][] back = new Face[this.ySize][this.xSize];
        Object[] top = new Face[this.xSize];
        Object[] bottom = new Face[this.xSize];
        Object[] left = new Face[this.ySize];
        Object[] right = new Face[this.ySize];
        Face.FaceBuilder faceBuilder = Face.builder();
        for (int z2 = 0; z2 < this.zSize; ++z2) {
            faceBuilder.z(z2);
            Layer layer = this.layers[z2];
            for (VoxelType type : VoxelType.renderable()) {
                List results = finalResult.computeIfAbsent(type, ignored -> new ArrayList());
                for (int y2 = 0; y2 < this.ySize; ++y2) {
                    faceBuilder.minY(y2).maxY(y2);
                    Object[] rowFront = front[y2];
                    Object[] rowBack = back[y2];
                    Arrays.fill(rowFront, null);
                    Arrays.fill(rowBack, null);
                    Arrays.fill(top, null);
                    Arrays.fill(bottom, null);
                    for (int x2 = 0; x2 < this.xSize; ++x2) {
                        if (voxels.getType(x2, y2, z2) != type) continue;
                        faceBuilder.minX(x2).maxX(x2).u1(layer.fetchU((float)x2 + 0.01f, this.xSize)).u2(layer.fetchU((float)x2 + 0.99f, this.xSize)).v1(layer.fetchV((float)y2 + 0.01f, this.ySize)).v2(layer.fetchV((float)y2 + 0.99f, this.ySize));
                        if (voxels.getFace(x2, y2, z2, Dir.Front)) {
                            rowFront[x2] = faceBuilder.dir(Dir.Front).build();
                        }
                        if (voxels.getFace(x2, y2, z2, Dir.Back)) {
                            rowBack[x2] = faceBuilder.dir(Dir.Back).build();
                        }
                        faceBuilder.v1(layer.fetchV((float)y2 + 0.01f, this.ySize)).v2(layer.fetchV((float)y2 + 0.99f, this.ySize));
                        if (voxels.getFace(x2, y2, z2, Dir.Up)) {
                            top[x2] = faceBuilder.dir(Dir.Up).build();
                        }
                        if (!voxels.getFace(x2, y2, z2, Dir.Down)) continue;
                        bottom[x2] = faceBuilder.dir(Dir.Down).build();
                    }
                    strategy.mergeSide((Face[])top);
                    strategy.mergeSide((Face[])bottom);
                    VoxelCompiler.unwrap((Face[])top, (List<Face>)results);
                    VoxelCompiler.unwrap((Face[])bottom, (List<Face>)results);
                }
                strategy.merge(back);
                strategy.merge(front);
                VoxelCompiler.unwrap(back, (List<Face>)results);
                VoxelCompiler.unwrap(front, (List<Face>)results);
                for (int x3 = 0; x3 < this.xSize; ++x3) {
                    Arrays.fill(left, null);
                    Arrays.fill(right, null);
                    faceBuilder.minX(x3).maxX(x3);
                    for (int y3 = 0; y3 < this.ySize; ++y3) {
                        if (voxels.getType(x3, y3, z2) != type) continue;
                        faceBuilder.minY(y3).maxY(y3).u1(layer.fetchU((float)x3 + 0.01f, this.xSize)).u2(layer.fetchU((float)x3 + 0.99f, this.xSize)).v1(layer.fetchV((float)y3 + 0.01f, this.ySize)).v2(layer.fetchV((float)y3 + 0.99f, this.ySize));
                        if (voxels.getFace(x3, y3, z2, Dir.Left)) {
                            left[y3] = faceBuilder.dir(Dir.Left).build();
                        }
                        if (!voxels.getFace(x3, y3, z2, Dir.Right)) continue;
                        right[y3] = faceBuilder.dir(Dir.Right).build();
                    }
                    strategy.mergeSide((Face[])left);
                    strategy.mergeSide((Face[])right);
                    VoxelCompiler.unwrap((Face[])left, (List<Face>)results);
                    VoxelCompiler.unwrap((Face[])right, (List<Face>)results);
                }
                finalResult.put(type, results);
            }
        }
        return finalResult;
    }
}

