/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.animfix;

import com.falsepattern.falsetweaks.modules.animfix.AnimationUpdateBatcherRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.profiler.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SideOnly(value=Side.CLIENT)
@Mixin(value={TextureUtil.class})
public abstract class TextureUtil_ProfiledMixin {
    private static Profiler theProfiler;

    @Inject(method={"uploadTextureMipmap"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private static void uploadTextureBatchable(int[][] texture, int width, int height, int xOffset, int yOffset, boolean ignored1, boolean ignored2, CallbackInfo ci) {
        if (theProfiler == null) {
            theProfiler = Minecraft.func_71410_x().field_71424_I;
        }
        if (AnimationUpdateBatcherRegistry.batcher != null) {
            theProfiler.func_76320_a("copyToBatch");
            boolean ended = AnimationUpdateBatcherRegistry.batcher.scheduleUpload(texture, width, height, xOffset, yOffset);
            theProfiler.func_76319_b();
            if (ended) {
                ci.cancel();
                return;
            }
        }
        theProfiler.func_76320_a("uploadUnbatched");
    }

    @Inject(method={"uploadTextureMipmap"}, at={@At(value="RETURN")}, require=1)
    private static void uploadUnbatchedEnd(CallbackInfo ci) {
        theProfiler.func_76319_b();
    }
}

