/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.natives;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.modules.natives.CPUID;
import com.falsepattern.falsetweaks.modules.natives.NativeLoader;
import com.falsepattern.falsetweaks.modules.natives.UnsupportedPlatformException;
import com.falsepattern.falsetweaks.modules.natives.camera.Clipping;
import com.falsepattern.falsetweaks.modules.natives.panama.Init;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public class Natives {
    private static boolean isJNI = false;
    private static boolean isPanama = false;

    public static void load() throws UnsupportedPlatformException {
        try {
            Class.forName("com.falsepattern.falsetweaks.modules.natives.panama.Init");
            Natives.loadPanama();
            isPanama = true;
            return;
        }
        catch (Throwable throwable) {
            Natives.loadJNI();
            isJNI = true;
            return;
        }
    }

    public static void loadJNI() throws UnsupportedPlatformException {
        Share.log.info("Initializing natives (JNI)");
        NativeLoader loader = new NativeLoader(CPUID.class);
        try {
            FileUtils.deleteDirectory((File)loader.nativesDir.toFile());
            Files.createDirectories(loader.nativesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UnsupportedPlatformException(e);
        }
        Share.log.info("Loading JNI stubs");
        loader.loadNative("jni", null);
        Share.log.info("Loading CPUID natives");
        String libCPUID = loader.loadNative("cpuid", null);
        Share.log.info("Linking CPUID natives");
        CPUID.link(libCPUID);
        Share.log.info("Fetching CPU arch");
        String arch = CPUID.getCpuModel();
        Share.log.info("CPU arch: {}", new Object[]{arch});
        String libFT = null;
        if (ModuleConfig.CLIPPING_HELPER_OPTS) {
            Share.log.info("Loading FalseTweaks natives");
            libFT = loader.loadNative("FalseTweaks", arch);
        }
        if (ModuleConfig.CLIPPING_HELPER_OPTS) {
            Share.log.info("Linking native clipping helper");
            if (!Clipping.link(libFT)) {
                throw new UnsupportedPlatformException("Failed to initialize native clipping helper");
            }
        }
        Share.log.info("Natives initialized!");
    }

    private static void loadPanama() throws UnsupportedPlatformException {
        Init.load();
    }

    @Generated
    public static boolean isJNI() {
        return isJNI;
    }

    @Generated
    public static boolean isPanama() {
        return isPanama;
    }
}

