/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.natives;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.modules.natives.Unpacker;
import com.falsepattern.falsetweaks.modules.natives.UnsupportedPlatformException;
import com.falsepattern.lib.util.FileUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import lombok.Generated;

public class NativeLoader {
    public final Path nativesDir;
    private final Triple currentTriple;
    private final Unpacker unpacker;

    public NativeLoader(Class<?> root) throws UnsupportedPlatformException {
        String homeDirStr = System.getProperty("minecraft.sharedDataDir");
        if (homeDirStr == null) {
            homeDirStr = System.getenv("MINECRAFT_SHARED_DATA_DIR");
        }
        Path homeDir = homeDirStr == null ? FileUtil.getMinecraftHomePath() : Paths.get(homeDirStr, new String[0]);
        this.nativesDir = homeDir.resolve("falsepattern").resolve("natives").resolve("falsetweaks");
        try {
            Files.createDirectories(this.nativesDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.nativesDir.toFile().deleteOnExit();
        Arch arch = Arch.getCurrent();
        OS os = OS.getCurrent();
        LibC libc = os.libc();
        this.currentTriple = new Triple(arch, os, libc);
        URL res = root.getResource("natives.pak");
        if (res == null) {
            throw new UnsupportedPlatformException("No resource package found!");
        }
        this.unpacker = new Unpacker(res);
        try {
            Share.log.info("Pack file contents: {}", new Object[]{Arrays.toString(this.unpacker.names())});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String unpackNative(String libName, String cpu) throws UnsupportedPlatformException {
        String libNameSys = this.currentTriple.toLibName(libName, cpu);
        cpu = cpu == null ? ((Triple)this.currentTriple).arch.baselineModel : cpu;
        String libNameArchive = libName + "-" + this.currentTriple.toName() + "-" + cpu;
        Path libFile = this.nativesDir.resolve(libNameSys);
        try {
            this.unpacker.unpack(libNameArchive, libFile);
        }
        catch (IOException e) {
            throw new UnsupportedPlatformException(e);
        }
        libFile.toFile().deleteOnExit();
        return libNameArchive;
    }

    public String loadNative(String libName, String cpu) throws UnsupportedPlatformException {
        String libNameSys = this.currentTriple.toLibName(libName, cpu);
        cpu = cpu == null ? ((Triple)this.currentTriple).arch.baselineModel : cpu;
        String libNameArchive = libName + "-" + this.currentTriple.toName() + "-" + cpu;
        Path libFile = this.nativesDir.resolve(libNameSys);
        try {
            this.unpacker.unpack(libNameArchive, libFile);
        }
        catch (IOException e) {
            throw new UnsupportedPlatformException(e);
        }
        String absolutePath = libFile.toAbsolutePath().toString();
        try {
            System.load(absolutePath);
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsupportedPlatformException(e);
        }
        libFile.toFile().deleteOnExit();
        return absolutePath;
    }

    private static enum LibC {
        GNU,
        None;


        public String getName() {
            switch (this) {
                case GNU: {
                    return "gnu";
                }
                case None: {
                    return "none";
                }
            }
            throw new AssertionError((Object)"Unreachable");
        }
    }

    private static enum Arch {
        X64("x86_64"),
        ARM64("generic");

        public final String baselineModel;

        static Arch getCurrent() throws UnsupportedPlatformException {
            boolean isX86;
            boolean is64Bit;
            String osArch = System.getProperty("os.arch");
            boolean bl = is64Bit = osArch.contains("64") || osArch.startsWith("armv8") || osArch.startsWith("aarch64");
            if (!is64Bit) {
                throw new UnsupportedPlatformException("Natives only support 64-bit systems");
            }
            boolean isArm = osArch.startsWith("arm") || osArch.startsWith("aarch64");
            boolean bl2 = isX86 = osArch.startsWith("x86") || osArch.startsWith("amd64");
            if (isArm) {
                return ARM64;
            }
            if (isX86) {
                return X64;
            }
            throw new UnsupportedPlatformException("Unsupported CPU architecture " + osArch);
        }

        public String getName() {
            switch (this) {
                case X64: {
                    return "x86_64";
                }
                case ARM64: {
                    return "aarch64";
                }
            }
            throw new AssertionError((Object)"Unreachable");
        }

        @Generated
        private Arch(String baselineModel) {
            this.baselineModel = baselineModel;
        }
    }

    private static enum OS {
        Windows,
        Linux,
        MacOS;


        public static OS getCurrent() throws UnsupportedPlatformException {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                return Windows;
            }
            if (osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("SunOS") || osName.startsWith("Unix")) {
                return Linux;
            }
            if (osName.startsWith("Mac OS X") || osName.startsWith("Darwin")) {
                return MacOS;
            }
            throw new UnsupportedPlatformException("Unsupported OS " + osName);
        }

        public String getName() {
            switch (this) {
                case Windows: {
                    return "windows";
                }
                case Linux: {
                    return "linux";
                }
                case MacOS: {
                    return "macos";
                }
            }
            throw new AssertionError((Object)"Unreachable");
        }

        public LibC libc() {
            switch (this) {
                case MacOS: {
                    return LibC.None;
                }
            }
            return LibC.GNU;
        }
    }

    private static class Triple {
        private final Arch arch;
        private final OS os;
        private final LibC libc;

        public String toLibName(String libName, String cpu) {
            StringBuilder nameBuilder = new StringBuilder();
            cpu = cpu == null ? this.arch.baselineModel : cpu;
            switch (this.os) {
                case Linux: 
                case MacOS: {
                    nameBuilder.append("lib");
                }
            }
            nameBuilder.append(libName);
            nameBuilder.append('-').append(this.arch.getName()).append('-').append(this.os.getName()).append('-').append(this.libc.getName()).append('-').append(cpu);
            switch (this.os) {
                case Windows: {
                    nameBuilder.append(".dll");
                    break;
                }
                case Linux: {
                    nameBuilder.append(".so");
                    break;
                }
                case MacOS: {
                    nameBuilder.append(".dylib");
                }
            }
            return nameBuilder.toString();
        }

        public String toName() {
            return this.arch.getName() + "-" + this.os.getName() + "-" + this.libc.getName();
        }

        @Generated
        public Triple(Arch arch, OS os, LibC libc) {
            this.arch = arch;
            this.os = os;
            this.libc = libc;
        }
    }
}

