/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks;

import com.falsepattern.falsetweaks.MultiLineLoadingException;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.proxy.CommonProxy;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import javax.swing.JOptionPane;
import net.minecraft.util.EnumChatFormatting;

@Mod(modid="falsetweaks", version="4.2.4", name="FalseTweaks", acceptedMinecraftVersions="[1.7.10]", guiFactory="com.falsepattern.falsetweaks.config.FalseTweaksGuiFactory", acceptableRemoteVersions="*", dependencies="required-after:falsepatternlib@[1.9.1,);after:gtnhlib@[0.5.21,);")
public class FalseTweaks {
    @SidedProxy(clientSide="com.falsepattern.falsetweaks.proxy.ClientProxy", serverSide="com.falsepattern.falsetweaks.proxy.ServerProxy")
    private static CommonProxy proxy;

    private static void builtinMod(String modname) {
        FalseTweaks.createSidedException("Remove " + modname + " from your mods directory.\nIt has been merged into FalseTweaks!");
    }

    public static void createSidedException(String text) {
        String sanitizedText = text;
        for (EnumChatFormatting fmt : EnumChatFormatting.values()) {
            sanitizedText = sanitizedText.replace(fmt.toString(), "");
        }
        if (FMLLaunchHandler.side().isClient()) {
            if (Loader.isModLoaded((String)"DragonRealmCore")) {
                JOptionPane.showMessageDialog(null, sanitizedText, "Failed to launch, the game will crash", 0);
            }
            throw ClientHelper.createException(text, sanitizedText);
        }
        throw new Error(sanitizedText);
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
        proxy.construct(e);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        if (Loader.isModLoaded((String)"neodymium")) {
            FalseTweaks.createSidedException("FalseTweaks is not compatible with Neodymium since 4.0.0.\nReplace Neodymium with Beddium.");
        }
        if (Loader.isModLoaded((String)"optifine") && ModuleConfig.THREADED_CHUNK_UPDATES()) {
            FalseTweaks.createSidedException("FalseTweaks threaded rendering is not compatible with OptiFine since 4.0.0.\nDisable threaded rendering, or replace OptiFine with Beddium (and SwanSong if you want shaders).");
        }
        if (Loader.isModLoaded((String)"animfix")) {
            FalseTweaks.builtinMod("animfix");
        }
        if (Loader.isModLoaded((String)"triangulator")) {
            FalseTweaks.builtinMod("triangulator");
        }
        if (Loader.isModLoaded((String)"DynamicLights")) {
            FalseTweaks.createSidedException("Remove the DynamicLights mod and restart the game!\nFalseTweaks has built-in dynamic lights support.");
        }
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent e) {
        proxy.loadComplete(e);
    }

    private static class ClientHelper {
        private ClientHelper() {
        }

        private static RuntimeException createException(String text, String sanText) {
            return new MultiLineLoadingException(text, sanText);
        }
    }
}

