/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.animfix;

import com.falsepattern.falsetweaks.api.animfix.IAnimationUpdateBatcher;
import com.falsepattern.falsetweaks.api.animfix.IAnimationUpdateBatcherFactory;
import com.falsepattern.falsetweaks.modules.animfix.DefaultAnimationUpdateBatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;

public class AnimationUpdateBatcherRegistry {
    private static final List<Integer> priorities = new ArrayList<Integer>();
    private static final Map<Integer, IAnimationUpdateBatcherFactory> factories = new HashMap<Integer, IAnimationUpdateBatcherFactory>();
    public static TextureMap currentAtlas = null;
    public static IAnimationUpdateBatcher batcher = null;
    public static String currentName = null;

    public static void registerBatcherFactory(IAnimationUpdateBatcherFactory factory, int priority) {
        while (priorities.contains(priority)) {
            ++priority;
        }
        priorities.add(priority);
        factories.put(priority, factory);
        priorities.sort(Comparator.naturalOrder());
    }

    public static IAnimationUpdateBatcher newBatcher(int xOffset, int yOffset, int width, int height, int mipLevel) {
        for (Integer priority : priorities) {
            IAnimationUpdateBatcherFactory factory = factories.get(priority);
            IAnimationUpdateBatcher batcher = factory.createBatcher(xOffset, yOffset, width, height, mipLevel);
            if (batcher == null) continue;
            return batcher;
        }
        throw new IllegalStateException("Could not construct animation update batcher");
    }

    static {
        AnimationUpdateBatcherRegistry.registerBatcherFactory(DefaultAnimationUpdateBatcher::new, 0);
    }
}

