/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.triangulator.calibration;

import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.config.TriangulatorConfig;
import com.falsepattern.falsetweaks.modules.triangulator.calibration.CalibrationGUI;
import com.falsepattern.lib.config.ConfigurationManager;
import com.falsepattern.lib.text.FormattedText;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.lwjgl.opengl.GL11;

public class Calibration {
    private static final Calibration INSTANCE = new Calibration();
    private static boolean calibrateRequest = false;

    public static void registerBus() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    public static void setCalibration(boolean flip) {
        TriangulatorConfig.Calibration.FLIP_DIAGONALS = flip;
        TriangulatorConfig.Calibration.GPU_HASH = Calibration.gpuHash();
        ConfigurationManager.saveToFile((boolean)true, (Class[])new Class[]{TriangulatorConfig.Calibration.class});
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }

    private static String gpuHash() {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(Calibration.gpu().getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static String gpu() {
        return GL11.glGetString((int)7937) + " GL version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936);
    }

    @SubscribeEvent
    public void onSinglePlayer(EntityJoinWorldEvent e) {
        if (TriangulatorConfig.SUPPRESS_CALIBRATION) {
            return;
        }
        if (!(e.entity instanceof EntityPlayerSP)) {
            return;
        }
        if (Calibration.gpuHash().equals(TriangulatorConfig.Calibration.GPU_HASH)) {
            return;
        }
        if (ModuleConfig.TRIANGULATOR) {
            FormattedText alert = FormattedText.parse((String)(EnumChatFormatting.RED + I18n.func_135052_a((String)"chat.triangulator.calibration.message", (Object[])new Object[0])));
            List text = alert.toChatText();
            ClickEvent ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triangulator_calibrate");
            for (ChatComponentText t : text) {
                t.func_150256_b().func_150241_a(ce);
                ((EntityPlayerSP)e.entity).func_145747_a((IChatComponent)t);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (calibrateRequest) {
            calibrateRequest = false;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new CalibrationGUI());
        }
    }

    @Generated
    private Calibration() {
    }

    public static class CalibrationCommand
    extends CommandBase {
        public String func_71517_b() {
            return "triangulator_calibrate";
        }

        public int func_82362_a() {
            return 0;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/triangulator_calibrate";
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            calibrateRequest = true;
        }
    }
}

