/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.occlusion.optifine;

import com.falsepattern.falsetweaks.asm.modules.occlusion.optifine.LazyOptiFineCheck;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class RenderGlobalDeOptimizer
implements TurboClassTransformer {
    private static final String OWNER_INTERNAL_NAME = "net/minecraft/client/renderer/RenderGlobal";
    private static final String BAD_FIELD_DESC = "LCompactArrayList;";
    private static final String BAD_METHOD_OWNER = "CompactArrayList";
    private static final String TARGET_FIELD_DESC = "Ljava/util/List;";
    private static final String TARGET_METHOD_OWNER = "java/util/List";

    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "RenderGlobalDeOptimizer";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!"net.minecraft.client.renderer.RenderGlobal".equals(className)) {
            return false;
        }
        return LazyOptiFineCheck.hasOptiFine();
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        boolean modified = false;
        for (MethodNode method : cn.methods) {
            if (method.name.equals("<init>") || method.name.equals("<clinit>")) continue;
            for (AbstractInsnNode insn : method.instructions) {
                if (insn instanceof FieldInsnNode) {
                    FieldInsnNode field = (FieldInsnNode)insn;
                    if (!OWNER_INTERNAL_NAME.equals(field.owner) || !BAD_FIELD_DESC.equals(field.desc)) continue;
                    field.desc = TARGET_FIELD_DESC;
                    modified = true;
                    continue;
                }
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode mInsn = (MethodInsnNode)insn;
                    if (!BAD_METHOD_OWNER.equals(mInsn.owner)) continue;
                    mInsn.owner = TARGET_METHOD_OWNER;
                    modified = true;
                    continue;
                }
                if (!(insn instanceof TypeInsnNode)) continue;
                TypeInsnNode tInsn = (TypeInsnNode)insn;
                if (!BAD_FIELD_DESC.equals(tInsn.desc)) continue;
                tInsn.desc = TARGET_FIELD_DESC;
                modified = true;
            }
        }
        return modified;
    }
}

