/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.dynlights.base;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.api.dynlights.DynamicLightsDriver;
import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.falsetweaks.modules.dynlights.DynamicLightsDrivers;
import com.falsepattern.falsetweaks.modules.dynlights.base.DynamicLight;
import com.falsepattern.falsetweaks.modules.dynlights.base.OffhandMod;
import com.falsepattern.lib.util.MathUtil;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class DynamicLights
implements DynamicLightsDriver {
    public static final DynamicLights INSTANCE = new DynamicLights();
    private static final Int2ObjectMap<DynamicLight> mapDynamicLights = new Int2ObjectArrayMap(1024);
    private static final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final double MAX_DIST = 16.0;
    private static final double MAX_DIST_SQ = 256.0;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static long timeUpdateMs = 0L;

    private DynamicLights() {
        if (!Compat.optiFineHasDynamicLights()) {
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    private static ReentrantReadWriteLock.WriteLock busyWaitWriteLock() {
        ReentrantReadWriteLock.WriteLock lock = rwLock.writeLock();
        while (!lock.tryLock()) {
            Thread.yield();
        }
        return lock;
    }

    private static ReentrantReadWriteLock.ReadLock busyWaitReadLock() {
        ReentrantReadWriteLock.ReadLock lock = rwLock.readLock();
        while (!lock.tryLock()) {
            Thread.yield();
        }
        return lock;
    }

    private static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    public static int getLightLevel(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.field_150939_a;
            if (block != null) {
                return block.func_149750_m();
            }
        }
        if (item == Items.field_151129_at) {
            return Blocks.field_150353_l.func_149750_m();
        }
        if (item == Items.field_151072_bj || item == Items.field_151065_br) {
            return 10;
        }
        if (item == Items.field_151114_aO) {
            return 8;
        }
        if (item == Items.field_151064_bs) {
            return 8;
        }
        return item == Items.field_151156_bN ? Blocks.field_150461_bJ.func_149750_m() / 2 : 0;
    }

    private static ItemStack getItemStack(EntityItem entityItem) {
        return entityItem.func_70096_w().func_82710_f(10);
    }

    @SubscribeEvent
    public void onReload(ConfigChangedEvent e) {
        if (e.modID.equals("falsetweaks")) {
            this.removeLights(Minecraft.func_71410_x().field_71438_f);
        }
    }

    @Override
    public boolean enabled() {
        return DynamicLightsDrivers.isDynamicLights();
    }

    @Override
    public void entityAdded(Entity entityIn, RenderGlobal renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entityRemoved(Entity entityIn, RenderGlobal renderGlobal) {
        ReentrantReadWriteLock.WriteLock lock = DynamicLights.busyWaitWriteLock();
        try {
            DynamicLight dynamicLight = (DynamicLight)mapDynamicLights.remove(entityIn.func_145782_y());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(RenderGlobal renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs >= timeUpdateMs + 50L) {
            timeUpdateMs = timeNowMs;
            ReentrantReadWriteLock.WriteLock lock = DynamicLights.busyWaitWriteLock();
            try {
                this.updateMapDynamicLights(renderGlobal);
                if (!mapDynamicLights.isEmpty()) {
                    for (DynamicLight dynamicLight : mapDynamicLights.values()) {
                        dynamicLight.update(renderGlobal);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void updateMapDynamicLights(RenderGlobal renderGlobal) {
        block5: {
            WorldClient world;
            block6: {
                boolean lightHand;
                block4: {
                    world = renderGlobal.field_72769_h;
                    if (world == null) {
                        this.removeLights(renderGlobal);
                    }
                    if (world == null) {
                        return;
                    }
                    boolean lightEntity = DynamicLightsDrivers.isDynamicEntityLight();
                    lightHand = DynamicLightsDrivers.isDynamicHandLight();
                    if (!lightEntity || !lightHand) break block4;
                    for (Entity entity : world.func_72910_y()) {
                        this.updateMapDynamicLightsEntity(renderGlobal, entity);
                    }
                    break block5;
                }
                if (!lightHand) break block6;
                EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
                if (player == null) break block5;
                this.updateMapDynamicLightsEntity(renderGlobal, (Entity)player);
                break block5;
            }
            EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
            for (Entity entity : world.func_72910_y()) {
                if (entity == player) continue;
                this.updateMapDynamicLightsEntity(renderGlobal, entity);
            }
        }
    }

    private void updateMapDynamicLightsEntity(RenderGlobal renderGlobal, Entity entity) {
        int lightLevel = this.getLightLevel(entity);
        if (lightLevel > 0) {
            int key = entity.func_145782_y();
            DynamicLight dynamicLight = (DynamicLight)mapDynamicLights.get(key);
            if (dynamicLight == null) {
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, (Object)dynamicLight);
            }
        } else {
            int key = entity.func_145782_y();
            DynamicLight dynamicLight = (DynamicLight)mapDynamicLights.remove(key);
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    @Override
    public int getCombinedLight(int x, int y, int z, int combinedLight) {
        double lightPlayer = this.getLightLevel(x, y, z);
        return DynamicLights.getCombinedLight(lightPlayer, combinedLight);
    }

    @Override
    public int getCombinedLight(Entity entity, int combinedLight) {
        double lightPlayer = this.getLightLevel(entity);
        return DynamicLights.getCombinedLight(lightPlayer, combinedLight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getLightLevel(int x, int y, int z) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase rve = mc.field_71451_h;
        double lightLevelMax = 0.0;
        ReentrantReadWriteLock.ReadLock lock = DynamicLights.busyWaitReadLock();
        try {
            for (DynamicLight dynamicLight : mapDynamicLights.values()) {
                double light;
                int dynamicLightLevel;
                boolean isHand;
                boolean bl = isHand = dynamicLight.getEntity() == rve;
                if (isHand && !DynamicLightsDrivers.isDynamicHandLight() || !isHand && !DynamicLightsDrivers.isDynamicEntityLight() || (dynamicLightLevel = dynamicLight.getLastLightLevel()) <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)x - px;
                double dy = (double)y - py;
                double dz = (double)z - pz;
                if (dynamicLight.isUnderwater()) {
                    dynamicLightLevel = MathUtil.clamp((int)(dynamicLightLevel - 2), (int)0, (int)15);
                    dx *= 2.0;
                    dy *= 2.0;
                    dz *= 2.0;
                }
                if (FTDynamicLights.isCircular()) {
                    double distSq = dx * dx + dy * dy + dz * dz;
                    light = distSq <= 256.0 ? (double)MathUtil.clamp((float)((float)dynamicLightLevel - MathUtil.sqrt((double)distSq)), (float)0.0f, (float)15.0f) : 0.0;
                } else {
                    dx = Math.abs(dx);
                    dy = Math.abs(dy);
                    dz = Math.abs(dz);
                    double dist = Math.max(dx - 0.25, 0.0) + Math.max(dy - 0.25, 0.0) + Math.max(dz - 0.25, 0.0);
                    light = MathUtil.clamp((double)((double)dynamicLightLevel - dist), (double)0.0, (double)15.0);
                }
                if (!(light > lightLevelMax)) continue;
                lightLevelMax = light;
            }
        }
        finally {
            lock.unlock();
        }
        return MathUtil.clamp((double)lightLevelMax, (double)0.0, (double)15.0);
    }

    public int getLightLevel(Entity entity) {
        EntityCreeper entityCreeper;
        boolean isHand;
        boolean bl = isHand = entity == Minecraft.func_71410_x().field_71451_h;
        if (isHand && !DynamicLightsDrivers.isDynamicHandLight() || !isHand && !DynamicLightsDrivers.isDynamicEntityLight()) {
            return 0;
        }
        if (entity.func_70027_ad()) {
            return 15;
        }
        if (entity instanceof EntityFireball) {
            return 15;
        }
        if (entity instanceof EntityTNTPrimed) {
            return 15;
        }
        if (entity instanceof EntityBlaze) {
            EntityBlaze entityBlaze = (EntityBlaze)entity;
            return entityBlaze.func_70845_n() ? 15 : 10;
        }
        if (entity instanceof EntityMagmaCube) {
            EntityMagmaCube emc = (EntityMagmaCube)entity;
            return (double)emc.field_70811_b > 0.6 ? 13 : 8;
        }
        if (entity instanceof EntityCreeper && (entityCreeper = (EntityCreeper)entity).func_70832_p() > 0) {
            return 15;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            ItemStack stackMain = living.func_70694_bm();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            ItemStack stackHead = living.func_71124_b(4);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int level = Math.max(levelMain, levelHead);
            if (entity instanceof EntityPlayer) {
                level = Math.max(level, DynamicLights.getLightLevel(OffhandMod.CURRENT.getOffhandItem((EntityPlayer)entity)));
            }
            return level;
        }
        if (entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            ItemStack itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLights(RenderGlobal renderGlobal) {
        ReentrantReadWriteLock.WriteLock lock = DynamicLights.busyWaitWriteLock();
        try {
            for (DynamicLight dynamicLight : mapDynamicLights.values()) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantReadWriteLock.WriteLock lock = DynamicLights.busyWaitWriteLock();
        try {
            mapDynamicLights.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getCount() {
        ReentrantReadWriteLock.ReadLock lock = DynamicLights.busyWaitReadLock();
        try {
            int n = mapDynamicLights.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }
}

