/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.underwatertrees;

import com.hro_basti.underwatertrees.commands.UnderwaterTreesBasicCommand;
import com.hro_basti.underwatertrees.i18n.Messages;
import com.hro_basti.underwatertrees.listeners.UnderwaterSaplingsListener;
import com.hro_basti.underwatertrees.metrics.Metrics;
import com.hro_basti.underwatertrees.update.UpdateChecker;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class Plugin
extends JavaPlugin {
    private UnderwaterSaplingsListener saplingsListener;
    private Messages messages;
    private long configLastModified;
    private int autoReloadTaskId = -1;
    private Metrics metrics;
    private UpdateChecker updateChecker;
    private int updateTaskId = -1;

    public void onEnable() {
        this.saveDefaultConfig();
        this.ensureConfigDefaults();
        String lang = this.getConfig().getString("language", "en_US");
        this.messages = new Messages(this, lang);
        this.getLogger().info(this.messages.get("plugin.language_set", Map.of("code", this.messages.getLanguage())));
        this.saplingsListener = new UnderwaterSaplingsListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.saplingsListener, (org.bukkit.plugin.Plugin)this);
        this.registerCommand("underwatertrees", new UnderwaterTreesBasicCommand(this, this.saplingsListener));
        this.getLogger().info(this.messages.get("plugin.enabled"));
        File cfgFile = new File(this.getDataFolder(), "config.yml");
        this.configLastModified = cfgFile.lastModified();
        this.updateAutoReloadFlag();
        this.initMetrics();
        this.initUpdateChecker();
    }

    public void onDisable() {
        this.stopAutoReload();
        this.stopUpdateCheck();
        if (this.messages == null) {
            this.getLogger().info("UnderwaterTrees plugin disabled.");
        } else {
            this.getLogger().info(this.messages.get("plugin.disabled"));
        }
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void reloadMessages() {
        if (this.messages == null) {
            String lang = this.getConfig().getString("language", "en_US");
            this.messages = new Messages(this, lang);
        } else {
            this.messages.reload(this.getConfig());
        }
        this.getLogger().info(this.messages.get("plugin.language_set", Map.of("code", this.messages.getLanguage())));
        this.updateAutoReloadFlag();
        this.initMetrics();
        this.initUpdateChecker();
    }

    private void startAutoReload() {
        this.autoReloadTaskId = Bukkit.getScheduler().runTaskTimer((org.bukkit.plugin.Plugin)this, () -> {
            try {
                File cfgFile = new File(this.getDataFolder(), "config.yml");
                long lm = cfgFile.lastModified();
                if (lm != 0L && lm != this.configLastModified) {
                    this.configLastModified = lm;
                    this.reloadConfig();
                    this.ensureConfigDefaults();
                    this.saplingsListener.applyConfig(this.getConfig());
                    this.reloadMessages();
                    this.getLogger().info("Config file changed externally \u2013 auto reloaded.");
                }
            }
            catch (Exception ex) {
                this.getLogger().warning("Error during auto-reload check: " + ex.getMessage());
            }
        }, 100L, 100L).getTaskId();
    }

    private void stopAutoReload() {
        if (this.autoReloadTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.autoReloadTaskId);
            this.autoReloadTaskId = -1;
        }
    }

    private void updateAutoReloadFlag() {
        boolean enabled = this.getConfig().getBoolean("auto-reload", true);
        if (enabled) {
            if (this.autoReloadTaskId == -1) {
                this.startAutoReload();
            }
        } else if (this.autoReloadTaskId != -1) {
            this.stopAutoReload();
            this.getLogger().info("Auto-reload disabled via config.");
        }
    }

    private void initMetrics() {
        boolean enabled = this.getConfig().getBoolean("metrics-enabled", true);
        if (enabled) {
            if (this.metrics == null) {
                this.metrics = new Metrics((org.bukkit.plugin.Plugin)this, 28005);
                this.metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.messages.getLanguage()));
                this.metrics.addCustomChart(new Metrics.SingleLineChart("sapling_count", this.saplingsListener::getSaplingCount));
                this.metrics.addCustomChart(new Metrics.SingleLineChart("soil_block_count", this.saplingsListener::getSoilCount));
            }
        } else if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
            this.getLogger().info("bStats metrics disabled via config.");
        }
    }

    private void initUpdateChecker() {
        boolean enabled = this.getConfig().getBoolean("update-check", true);
        if (!enabled) {
            this.stopUpdateCheck();
            return;
        }
        if (this.updateChecker == null) {
            this.updateChecker = new UpdateChecker(this);
        }
        this.updateChecker.checkNowAsync();
        long hours = Math.max(1L, this.getConfig().getLong("update-interval-hours", 24L));
        long periodTicks = hours * 60L * 60L * 20L;
        if (this.updateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.updateTaskId);
        }
        this.updateTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((org.bukkit.plugin.Plugin)this, () -> {
            try {
                this.updateChecker.checkNowAsync();
                if (this.updateChecker.isUpdateAvailable() && this.getConfig().getBoolean("notify-console", true)) {
                    this.getLogger().info("Update available: " + this.updateChecker.getRemoteVersion() + " (source: " + this.updateChecker.getRemoteSource() + ") " + (this.updateChecker.getRemoteUrl() != null ? this.updateChecker.getRemoteUrl() : ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 200L, periodTicks).getTaskId();
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(PlayerJoinEvent e) {
                if (!Plugin.this.getConfig().getBoolean("notify-op-join", true)) {
                    return;
                }
                if (!Plugin.this.updateChecker.isUpdateAvailable()) {
                    return;
                }
                Player p = e.getPlayer();
                if (!p.isOp() && !p.hasPermission("underwatertrees.update")) {
                    return;
                }
                String vLocal = Plugin.this.getDescription().getVersion();
                String vRemote = Plugin.this.updateChecker.getRemoteVersion();
                String url = Plugin.this.updateChecker.getRemoteUrl();
                p.sendMessage(Component.text((String)("UnderwaterTrees: New version " + vRemote + " available (you run " + vLocal + ")")).color((TextColor)NamedTextColor.YELLOW));
                if (url != null && !url.isEmpty()) {
                    p.sendMessage(Component.text((String)("More: " + url)).color((TextColor)NamedTextColor.GRAY));
                }
            }
        }, (org.bukkit.plugin.Plugin)this);
    }

    private void stopUpdateCheck() {
        if (this.updateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.updateTaskId);
            this.updateTaskId = -1;
        }
    }

    public void ensureConfigDefaults() {
        try (InputStream in = this.getResource("config.yml");){
            if (in == null) {
                return;
            }
            YamlConfiguration def = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            FileConfiguration cfg = this.getConfig();
            cfg.setDefaults((Configuration)def);
            cfg.options().copyDefaults(true);
            this.saveConfig();
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to merge default config: " + ex.getMessage());
        }
    }
}

