/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.underwatertrees.commands;

import com.hro_basti.underwatertrees.Plugin;
import com.hro_basti.underwatertrees.i18n.Messages;
import com.hro_basti.underwatertrees.listeners.UnderwaterSaplingsListener;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.Nullable;

public class UnderwaterTreesBasicCommand
implements BasicCommand {
    private final Plugin plugin;
    private final UnderwaterSaplingsListener listener;

    public UnderwaterTreesBasicCommand(Plugin plugin, UnderwaterSaplingsListener listener) {
        this.plugin = plugin;
        this.listener = listener;
    }

    public void execute(CommandSourceStack source, String[] args) {
        Messages msg = this.plugin.getMessages();
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!source.getSender().hasPermission("underwatertrees.reload")) {
                source.getSender().sendMessage(Component.text((String)msg.get("command.no_permission")).color((TextColor)NamedTextColor.RED));
                return;
            }
            this.plugin.reloadConfig();
            this.plugin.ensureConfigDefaults();
            this.listener.applyConfig(this.plugin.getConfig());
            this.plugin.reloadMessages();
            Messages msg2 = this.plugin.getMessages();
            source.getSender().sendMessage(Component.text((String)msg2.get("command.reloaded")).color((TextColor)NamedTextColor.GREEN));
            return;
        }
        source.getSender().sendMessage(Component.text((String)msg.get("command.usage", Map.of("label", "underwatertrees"))).color((TextColor)NamedTextColor.YELLOW));
    }

    @Nullable
    public String permission() {
        return "underwatertrees.reload";
    }
}

