/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.underwatertrees.i18n;

import com.hro_basti.underwatertrees.Plugin;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Messages {
    private final Plugin plugin;
    private final File langDir;
    private YamlConfiguration messages;
    private YamlConfiguration defaults;
    private String language;

    public Messages(Plugin plugin, String language) {
        this.plugin = plugin;
        this.langDir = new File(plugin.getDataFolder(), "lang");
        if (!this.langDir.exists()) {
            this.langDir.mkdirs();
        }
        this.ensureDefaultLangFile("en_US.yml");
        this.ensureDefaultLangFile("de_DE.yml");
        this.setLanguage(language);
    }

    private void ensureDefaultLangFile(String name) {
        String resourcePath;
        File f = new File(this.langDir, name);
        if (!f.exists() && this.plugin.getResource(resourcePath = "lang/" + name) != null) {
            this.plugin.saveResource(resourcePath, false);
        }
    }

    public void setLanguage(String language) {
        this.language = language;
        this.defaults = this.loadFromResource("lang/en_US.yml");
        File file = new File(this.langDir, language + ".yml");
        if (file.exists()) {
            this.messages = YamlConfiguration.loadConfiguration((File)file);
        } else {
            this.messages = this.loadFromResource("lang/" + language + ".yml");
            if (this.messages == null) {
                this.messages = new YamlConfiguration();
            }
        }
        if (this.defaults != null) {
            this.messages.setDefaults((Configuration)this.defaults);
            this.messages.options().copyDefaults(true);
        }
    }

    private YamlConfiguration loadFromResource(String path) {
        YamlConfiguration yamlConfiguration;
        InputStream in = this.plugin.getResource(path);
        if (in == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load resource " + path + ": " + e.getMessage());
                return null;
            }
        }
        reader.close();
        return yamlConfiguration;
    }

    public String get(String key) {
        return this.messages.getString(key, key);
    }

    public String get(String key, Map<String, String> placeholders) {
        String base = this.get(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                base = base.replace("{" + e.getKey() + "}", e.getValue());
            }
        }
        return base;
    }

    public String getLanguage() {
        return this.language;
    }

    public void reload(FileConfiguration config) {
        String lang = config.getString("language", this.language != null ? this.language : "en_US");
        this.setLanguage(lang);
    }
}

