/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.underwatertrees.listeners;

import com.hro_basti.underwatertrees.Plugin;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class UnderwaterSaplingsListener
implements Listener {
    private final Plugin plugin;
    private final Set<Material> saplings = EnumSet.noneOf(Material.class);
    private final Set<Material> validSoils = new HashSet<Material>();
    private boolean requireWaterAbove = true;

    public UnderwaterSaplingsListener(Plugin plugin) {
        this.plugin = plugin;
        this.applyConfig(plugin.getConfig());
    }

    public void applyConfig(FileConfiguration cfg) {
        this.saplings.clear();
        this.validSoils.clear();
        this.requireWaterAbove = cfg.getBoolean("require-water-above", false);
        boolean logStats = cfg.getBoolean("log-stats", true);
        boolean logDetail = cfg.getBoolean("log-detail", false);
        ConfigurationSection saplingSection = cfg.getConfigurationSection("saplings");
        if (saplingSection != null) {
            for (Object key : saplingSection.getKeys(false)) {
                boolean enabled = saplingSection.getBoolean((String)key, false);
                if (!enabled) continue;
                try {
                    Material m = Material.matchMaterial((String)((String)key).toUpperCase());
                    if (m == null) {
                        this.plugin.getLogger().warning("Unknown sapling/material key in config: " + (String)key);
                        continue;
                    }
                    String name = m.name();
                    if (name.endsWith("_SAPLING") || name.equals("MANGROVE_PROPAGULE")) {
                        this.saplings.add(m);
                        continue;
                    }
                    this.saplings.add(m);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().warning("Unknown sapling/material key in config: " + (String)key);
                }
            }
        } else {
            this.plugin.getLogger().warning("Config section 'saplings' missing; no saplings will be allowed.");
        }
        ConfigurationSection soilSection = cfg.getConfigurationSection("soils");
        if (soilSection != null) {
            for (String key : soilSection.getKeys(false)) {
                boolean enabled = soilSection.getBoolean(key, false);
                if (!enabled) continue;
                try {
                    Material m = Material.matchMaterial((String)key.toUpperCase());
                    if (m == null) {
                        this.plugin.getLogger().warning("Unknown soil material key in config: " + key);
                        continue;
                    }
                    this.validSoils.add(m);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().warning("Unknown soil material key in config: " + key);
                }
            }
        } else {
            this.plugin.getLogger().warning("Config section 'soils' missing; no soils will be valid.");
        }
        if (this.saplings.isEmpty() && this.validSoils.isEmpty()) {
            String[] defaultSaplings;
            String[] defaultSoils;
            this.plugin.getLogger().warning("No saplings and soils loaded; applying fallback defaults.");
            for (String n : defaultSoils = new String[]{"DIRT", "GRASS_BLOCK", "PODZOL", "COARSE_DIRT", "ROOTED_DIRT", "MOSS_BLOCK", "MUD"}) {
                Material m = Material.matchMaterial((String)n);
                if (m == null) continue;
                this.validSoils.add(m);
            }
            for (String n : defaultSaplings = new String[]{"OAK_SAPLING", "SPRUCE_SAPLING", "BIRCH_SAPLING", "JUNGLE_SAPLING", "ACACIA_SAPLING", "DARK_OAK_SAPLING", "CHERRY_SAPLING", "MANGROVE_PROPAGULE"}) {
                Material m = Material.matchMaterial((String)n);
                if (m == null) continue;
                this.saplings.add(m);
            }
        }
        if (logStats) {
            this.plugin.getLogger().info("Loaded soils: " + this.validSoils.size() + ", saplings: " + this.saplings.size() + ", require-water-above=" + this.requireWaterAbove + ", log-detail=" + logDetail);
        }
        if (logDetail) {
            if (!this.validSoils.isEmpty()) {
                this.plugin.getLogger().info("Soils:");
                for (Material m : this.validSoils) {
                    this.plugin.getLogger().info(" - " + m.name());
                }
            }
            if (!this.saplings.isEmpty()) {
                this.plugin.getLogger().info("Saplings:");
                for (Material m : this.saplings) {
                    this.plugin.getLogger().info(" - " + m.name());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlaceUnderwater(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material type = item.getType();
        if (!this.saplings.contains(type)) {
            return;
        }
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            return;
        }
        if (event.getBlockFace() != BlockFace.UP) {
            return;
        }
        Block placeBlock = clicked.getRelative(BlockFace.UP);
        if (this.requireWaterAbove && placeBlock.getType() != Material.WATER) {
            return;
        }
        if (!this.validSoils.contains(clicked.getType())) {
            return;
        }
        event.setCancelled(true);
        BlockData data = Bukkit.createBlockData((Material)type);
        if (data instanceof Sapling) {
            Sapling s = (Sapling)data;
            s.setStage(0);
            placeBlock.setBlockData((BlockData)s, false);
        } else {
            placeBlock.setType(type, false);
        }
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE) {
            int amount = item.getAmount();
            if (amount > 1) {
                item.setAmount(amount - 1);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
        }
        placeBlock.getWorld().playSound(placeBlock.getLocation(), Sound.BLOCK_GRASS_PLACE, 1.0f, 1.0f);
    }

    public int getSaplingCount() {
        return this.saplings.size();
    }

    public int getSoilCount() {
        return this.validSoils.size();
    }

    public Set<Material> getSaplings() {
        return Collections.unmodifiableSet(this.saplings);
    }

    public Set<Material> getValidSoils() {
        return Collections.unmodifiableSet(this.validSoils);
    }
}

