/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.underwatertrees.update;

import com.hro_basti.underwatertrees.Plugin;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class UpdateChecker {
    private final Plugin plugin;
    private volatile boolean updateAvailable = false;
    private volatile String remoteVersion = null;
    private volatile String remoteSource = null;
    private volatile String remoteUrl = null;
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);
    private static final String MODRINTH_SLUG = "underwatertrees";
    private static final String HANGAR_SLUG = "hro_basti/underwatertrees";

    public UpdateChecker(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getRemoteVersion() {
        return this.remoteVersion;
    }

    public String getRemoteSource() {
        return this.remoteSource;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void checkNowAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((org.bukkit.plugin.Plugin)this.plugin, this::checkOnce);
    }

    private void checkOnce() {
        if (!this.plugin.getConfig().getBoolean("update-check", true)) {
            return;
        }
        int mode = 0;
        try {
            mode = this.plugin.getConfig().getInt("update-sources", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<String> sources = switch (mode) {
            case 1 -> List.of("modrinth");
            case 2 -> List.of("hangar");
            default -> List.of("modrinth", "hangar");
        };
        for (String src : sources) {
            String s = src.toLowerCase(Locale.ROOT);
            try {
                if (!(s.equals("modrinth") ? this.checkModrinth() : s.equals("hangar") && this.checkHangar())) continue;
                return;
            }
            catch (Exception ex) {
                this.plugin.getLogger().fine("Update check failed for source: " + s + " - " + ex.getMessage());
            }
        }
    }

    private boolean checkModrinth() throws Exception {
        String slug = MODRINTH_SLUG;
        String url = "https://api.modrinth.com/v2/project/" + slug + "/version";
        String body = this.fetch(url);
        if (body == null || body.isEmpty()) {
            return false;
        }
        boolean includePre = this.plugin.getConfig().getBoolean("include-prereleases", false);
        boolean filterByMc = this.plugin.getConfig().getBoolean("filter-by-server-version", true);
        String mc = Bukkit.getMinecraftVersion();
        String mcPrefix = mc.contains(".") ? mc.substring(0, mc.lastIndexOf(46)) : mc;
        Pattern p = Pattern.compile("\\{[^}]*\\\"version_number\\\":\\\"([^\\\"]+)\\\"[^}]*} ");
        Matcher m = p.matcher(body + " ");
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String obj = body.substring(start, end);
            String ver = m.group(1);
            if (!includePre && obj.contains("\"version_type\":\"beta\"") || obj.contains("\"version_type\":\"alpha\"") || !obj.contains("paper") && !obj.contains("Paper") || filterByMc && !obj.contains("\"" + mc + "\"") && !obj.contains("\"" + mcPrefix + "\"")) continue;
            String local = this.getLocalVersion();
            if (this.isNewer(ver, local)) {
                this.updateAvailable = true;
                this.remoteVersion = ver;
                this.remoteSource = "modrinth";
                this.remoteUrl = "https://modrinth.com/plugin/" + slug + "/version/" + ver;
            } else {
                this.updateAvailable = false;
            }
            return true;
        }
        return false;
    }

    private boolean checkHangar() throws Exception {
        String slug = HANGAR_SLUG;
        String url = "https://hangar.papermc.io/api/v1/projects/" + slug + "/versions?limit=20";
        String body = this.fetch(url);
        if (body == null || body.isEmpty()) {
            return false;
        }
        boolean includePre = this.plugin.getConfig().getBoolean("include-prereleases", false);
        boolean filterByMc = this.plugin.getConfig().getBoolean("filter-by-server-version", true);
        String mc = Bukkit.getMinecraftVersion();
        String mcPrefix = mc.contains(".") ? mc.substring(0, mc.lastIndexOf(46)) : mc;
        Pattern p = Pattern.compile("\\{[^}]*\\}");
        Matcher m = p.matcher(body);
        while (m.find()) {
            String ver;
            boolean isRelease;
            String obj = m.group();
            boolean bl = isRelease = obj.contains("Release") || obj.contains("\"channel\":\"Release\"");
            if (!includePre && !isRelease || !obj.contains("PAPER") && !obj.contains("paper") || filterByMc && !obj.contains(mc) && !obj.contains(mcPrefix) || (ver = this.extractAny(obj, List.of("\"name\":\"", "\"version\":\""))) == null) continue;
            String local = this.getLocalVersion();
            if (this.isNewer(ver, local)) {
                this.updateAvailable = true;
                this.remoteVersion = ver;
                this.remoteSource = "hangar";
                this.remoteUrl = "https://hangar.papermc.io/" + slug + "/versions";
            } else {
                this.updateAvailable = false;
            }
            return true;
        }
        return false;
    }

    private String fetch(String url) throws Exception {
        HttpRequest req;
        HttpClient client = HttpClient.newBuilder().connectTimeout(TIMEOUT).build();
        HttpResponse<String> resp = client.send(req = HttpRequest.newBuilder(URI.create(url)).timeout(TIMEOUT).header("User-Agent", "UnderwaterTrees/" + this.getLocalVersion()).GET().build(), HttpResponse.BodyHandlers.ofString());
        if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
            return resp.body();
        }
        return null;
    }

    private String extractAny(String text, List<String> prefixes) {
        for (String pref : prefixes) {
            int s;
            int e;
            int i = text.indexOf(pref);
            if (i < 0 || (e = text.indexOf(34, s = i + pref.length())) <= s) continue;
            return text.substring(s, e);
        }
        return null;
    }

    private String getLocalVersion() {
        try {
            String v = this.plugin.getPluginMeta().getVersion();
            return v != null ? v : "0.0.0";
        }
        catch (Throwable t) {
            String v = this.plugin.getDescription().getVersion();
            return v != null ? v : "0.0.0";
        }
    }

    private boolean isNewer(String remote, String local) {
        int[] l;
        int[] r = this.parseSemVer(remote);
        if (r[0] != (l = this.parseSemVer(local))[0]) {
            return r[0] > l[0];
        }
        if (r[1] != l[1]) {
            return r[1] > l[1];
        }
        if (r[2] != l[2]) {
            return r[2] > l[2];
        }
        return false;
    }

    private int[] parseSemVer(String v) {
        int major = 0;
        int minor = 0;
        int patch = 0;
        try {
            String[] parts = v.split("-", 2)[0].split("\\.");
            if (parts.length > 0) {
                major = this.parseInt(parts[0]);
            }
            if (parts.length > 1) {
                minor = this.parseInt(parts[1]);
            }
            if (parts.length > 2) {
                patch = this.parseInt(parts[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[]{major, minor, patch};
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

