/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class ConfigWatcher
implements Runnable {
    private final JavaPlugin plugin;
    private final Supplier<File> fileSupplier;
    private final Runnable onChange;
    private final BooleanSupplier enabledSupplier;
    private final long intervalTicks;
    private BukkitTask task;
    private volatile Fingerprint lastFingerprint = Fingerprint.missing();

    private ConfigWatcher(JavaPlugin plugin, Supplier<File> fileSupplier, Runnable onChange, BooleanSupplier enabledSupplier, long intervalTicks) {
        this.plugin = plugin;
        this.fileSupplier = fileSupplier;
        this.onChange = onChange;
        this.enabledSupplier = enabledSupplier;
        this.intervalTicks = intervalTicks;
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public synchronized void start() {
        this.stop();
        this.refreshBaseline();
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this, this.intervalTicks, this.intervalTicks);
    }

    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void refreshBaseline() {
        this.lastFingerprint = this.fingerprint(this.fileSupplier.get(), this.lastFingerprint);
    }

    @Override
    public void run() {
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!this.enabledSupplier.getAsBoolean()) {
            return;
        }
        try {
            File file = this.fileSupplier.get();
            Fingerprint current = this.fingerprint(file, this.lastFingerprint);
            if (!current.equals(this.lastFingerprint)) {
                this.lastFingerprint = current;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        this.onChange.run();
                    }
                    catch (Throwable ex) {
                        this.plugin.getLogger().fine("Config watcher callback failed: " + ex.getMessage());
                    }
                });
            }
        }
        catch (Throwable ex) {
            this.plugin.getLogger().fine("Config watcher task failed: " + ex.getMessage());
        }
    }

    private Fingerprint fingerprint(File file, Fingerprint previous) {
        if (file == null || !file.exists()) {
            return Fingerprint.missing();
        }
        long modified = file.lastModified();
        long size = file.length();
        int hash = previous != null && previous.exists() && previous.modified == modified && previous.size == size ? previous.hash : this.computeHash(file);
        return new Fingerprint(modified, size, hash, true);
    }

    private int computeHash(File file) {
        int n;
        block9: {
            CRC32 crc = new CRC32();
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                int read;
                byte[] buffer = new byte[1024];
                while ((read = in.read(buffer)) != -1) {
                    crc.update(buffer, 0, read);
                }
                n = (int)crc.getValue();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.plugin.getLogger().fine("Config watcher hash error: " + ex.getMessage());
                    return -1;
                }
            }
            in.close();
        }
        return n;
    }

    private record Fingerprint(long modified, long size, int hash, boolean exists) {
        static Fingerprint missing() {
            return new Fingerprint(0L, -1L, 0, false);
        }
    }

    public static final class Builder {
        private static final long DEFAULT_INTERVAL_TICKS = 100L;
        private final JavaPlugin plugin;
        private Supplier<File> fileSupplier;
        private Runnable onChange;
        private BooleanSupplier enabledSupplier = () -> true;
        private long intervalTicks = 100L;

        private Builder(JavaPlugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
        }

        public Builder file(File file) {
            this.fileSupplier = () -> file;
            return this;
        }

        public Builder fileSupplier(Supplier<File> supplier) {
            this.fileSupplier = supplier;
            return this;
        }

        public Builder onChange(Runnable runnable) {
            this.onChange = runnable;
            return this;
        }

        public Builder enabledSupplier(BooleanSupplier supplier) {
            this.enabledSupplier = supplier;
            return this;
        }

        public Builder intervalTicks(long ticks) {
            this.intervalTicks = ticks;
            return this;
        }

        public Builder intervalSeconds(long seconds) {
            long safeSeconds = Math.max(1L, seconds);
            this.intervalTicks = safeSeconds * 20L;
            return this;
        }

        public ConfigWatcher build() {
            Objects.requireNonNull(this.fileSupplier, "fileSupplier");
            Objects.requireNonNull(this.onChange, "onChange");
            Objects.requireNonNull(this.enabledSupplier, "enabledSupplier");
            long ticks = this.intervalTicks <= 0L ? 100L : this.intervalTicks;
            return new ConfigWatcher(this.plugin, this.fileSupplier, this.onChange, this.enabledSupplier, ticks);
        }
    }
}

