/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class LangLoader {
    public static final String DEFAULT_LOCALE = "en_US";
    private static final String LANG_RESOURCE_PREFIX = "lang/";
    private static final Pattern LOCALE_PATTERN = Pattern.compile("^[a-z]{2}_[A-Z]{2}$");

    private LangLoader() {
    }

    public static List<String> getBundledLocales(JavaPlugin plugin) {
        TreeSet<String> locales = new TreeSet<String>();
        locales.addAll(LangLoader.scanBundledLocales(plugin));
        locales.addAll(LangLoader.scanDataLocales(plugin));
        if (locales.isEmpty()) {
            locales.add(DEFAULT_LOCALE);
        }
        return List.copyOf(locales);
    }

    public static void ensureBundledLocales(JavaPlugin plugin) {
        for (String locale : LangLoader.getBundledLocales(plugin)) {
            LangLoader.ensureLocaleFile(plugin, locale);
        }
    }

    public static List<String> syncLocale(JavaPlugin plugin, String locale) {
        ArrayList<String> added;
        String normalized = LangLoader.normalize(locale);
        if (normalized == null) {
            return Collections.emptyList();
        }
        File langFile = LangLoader.ensureLocaleFile(plugin, normalized);
        YamlConfiguration defaults = LangLoader.loadDefaults(plugin, normalized);
        if (defaults == null) {
            return Collections.emptyList();
        }
        YamlConfiguration target = YamlConfiguration.loadConfiguration((File)langFile);
        if (LangLoader.mergeSections((ConfigurationSection)target, (ConfigurationSection)defaults, "", added = new ArrayList<String>())) {
            try {
                target.save(langFile);
            }
            catch (IOException e) {
                plugin.getLogger().fine("Failed to sync lang file " + langFile.getName() + ": " + e.getMessage());
            }
        }
        return added;
    }

    public static YamlConfiguration loadLocale(JavaPlugin plugin, String locale) {
        LangLoader.ensureBundledLocales(plugin);
        String normalized = LangLoader.normalize(locale);
        if (normalized == null) {
            normalized = DEFAULT_LOCALE;
        }
        LangLoader.syncLocale(plugin, normalized);
        File langFile = LangLoader.ensureLocaleFile(plugin, normalized);
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)langFile);
        YamlConfiguration defaults = LangLoader.loadDefaults(plugin, DEFAULT_LOCALE);
        if (defaults != null) {
            configuration.setDefaults((Configuration)defaults);
            configuration.options().copyDefaults(true);
        }
        return configuration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YamlConfiguration loadLocaleResource(JavaPlugin plugin, String locale) {
        String normalized = LangLoader.normalize(locale);
        if (normalized == null) {
            normalized = DEFAULT_LOCALE;
        }
        try (InputStream in = plugin.getResource(LANG_RESOURCE_PREFIX + normalized + ".yml");){
            if (in == null) {
                YamlConfiguration yamlConfiguration2 = null;
                return yamlConfiguration2;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            return yamlConfiguration;
        }
        catch (IOException e) {
            plugin.getLogger().fine("Failed to read lang resource " + normalized + ": " + e.getMessage());
            return null;
        }
    }

    private static File ensureLocaleFile(JavaPlugin plugin, String locale) {
        File out;
        File langDir = new File(plugin.getDataFolder(), "lang");
        if (!langDir.exists() && !langDir.mkdirs()) {
            plugin.getLogger().fine("Could not create lang directory " + langDir.getAbsolutePath());
        }
        if ((out = new File(langDir, locale + ".yml")).exists()) {
            return out;
        }
        try {
            plugin.saveResource(LANG_RESOURCE_PREFIX + locale + ".yml", false);
        }
        catch (IllegalArgumentException ignored) {
            try {
                if (!out.createNewFile()) {
                    plugin.getLogger().fine("Could not create lang file " + out.getName());
                }
            }
            catch (IOException e) {
                plugin.getLogger().fine("Failed to create lang file " + out.getName() + ": " + e.getMessage());
            }
        }
        return out;
    }

    private static YamlConfiguration loadDefaults(JavaPlugin plugin, String locale) {
        YamlConfiguration defaults = LangLoader.loadLocaleResource(plugin, locale);
        if (defaults == null && !DEFAULT_LOCALE.equals(locale)) {
            defaults = LangLoader.loadLocaleResource(plugin, DEFAULT_LOCALE);
        }
        return defaults;
    }

    private static Set<String> scanBundledLocales(JavaPlugin plugin) {
        File jar = LangLoader.resolvePluginJar(plugin);
        if (jar == null || !jar.isFile()) {
            return Collections.emptySet();
        }
        TreeSet<String> locales = new TreeSet<String>();
        try (JarFile jarFile = new JarFile(jar);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String locale;
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).startsWith(LANG_RESOURCE_PREFIX) || !name.endsWith(".yml") || !LangLoader.isLocaleIdentifier(locale = name.substring(LANG_RESOURCE_PREFIX.length(), name.length() - 4))) continue;
                locales.add(locale);
            }
        }
        catch (IOException e) {
            plugin.getLogger().fine("Could not inspect bundled locales: " + e.getMessage());
        }
        if (!locales.contains(DEFAULT_LOCALE)) {
            locales.add(DEFAULT_LOCALE);
        }
        return locales;
    }

    private static Set<String> scanDataLocales(JavaPlugin plugin) {
        File langDir = new File(plugin.getDataFolder(), "lang");
        if (!langDir.exists()) {
            return Collections.emptySet();
        }
        File[] files = langDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            return Collections.emptySet();
        }
        TreeSet<String> locales = new TreeSet<String>();
        for (File file : files) {
            String name2 = file.getName();
            String locale = name2.substring(0, name2.length() - 4);
            if (!LangLoader.isLocaleIdentifier(locale)) continue;
            locales.add(locale);
        }
        return locales;
    }

    private static boolean isLocaleIdentifier(String candidate) {
        return candidate != null && LOCALE_PATTERN.matcher(candidate).matches();
    }

    private static File resolvePluginJar(JavaPlugin plugin) {
        try {
            URL location = plugin.getClass().getProtectionDomain().getCodeSource().getLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.toURI());
            return file.exists() ? file : null;
        }
        catch (URISyntaxException ex) {
            plugin.getLogger().fine("Could not resolve plugin jar location: " + ex.getMessage());
            return null;
        }
    }

    private static boolean mergeSections(ConfigurationSection target, ConfigurationSection defaults, String pathPrefix, List<String> addedKeys) {
        boolean changed = false;
        if (defaults == null) {
            return false;
        }
        for (String key : defaults.getKeys(false)) {
            String fullKey;
            String string = fullKey = pathPrefix == null || pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            if (defaults.isConfigurationSection(key)) {
                ConfigurationSection defChild = defaults.getConfigurationSection(key);
                ConfigurationSection tgtChild = target.getConfigurationSection(key);
                if (tgtChild == null) {
                    tgtChild = target.createSection(key);
                    changed = true;
                }
                if (defChild == null) continue;
                changed |= LangLoader.mergeSections(tgtChild, defChild, fullKey, addedKeys);
                continue;
            }
            if (target.contains(key)) continue;
            target.set(key, defaults.get(key));
            if (addedKeys != null) {
                addedKeys.add(fullKey);
            }
            changed = true;
        }
        return changed;
    }

    private static String normalize(String locale) {
        if (locale == null) {
            return null;
        }
        String trimmed = locale.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (trimmed.endsWith(".yml")) {
            return trimmed.substring(0, trimmed.length() - 4);
        }
        return trimmed;
    }
}

