/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import com.github.hrobasti.turtlelib.helper.LangLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageService {
    private static final MiniMessage MINI = MiniMessage.miniMessage();
    private static final PlainTextComponentSerializer PLAIN = PlainTextComponentSerializer.plainText();
    private final JavaPlugin plugin;
    private final Map<String, String> messages = new HashMap<String, String>();
    private final String defaultPrefixRaw;
    private final String defaultPrefixLabel;
    private String prefixRaw;
    private String prefixLabel;
    private String currentLocale = "en_US";

    public MessageService(JavaPlugin plugin, String defaultPrefixRaw, String defaultPrefixLabel) {
        this.plugin = plugin;
        this.defaultPrefixRaw = defaultPrefixRaw != null && !defaultPrefixRaw.isBlank() ? defaultPrefixRaw : "<gray>[<prefix_label>]</gray>";
        this.defaultPrefixLabel = defaultPrefixLabel != null && !defaultPrefixLabel.isBlank() ? defaultPrefixLabel : plugin.getName();
        this.prefixRaw = this.defaultPrefixRaw;
        this.prefixLabel = this.defaultPrefixLabel;
    }

    public static List<String> getBundledLocales(JavaPlugin plugin) {
        return LangLoader.getBundledLocales(plugin);
    }

    public void load(String locale) {
        String normalized;
        this.messages.clear();
        this.currentLocale = normalized = this.normalize(locale);
        YamlConfiguration cfg = LangLoader.loadLocale(this.plugin, normalized);
        this.collectMessages((ConfigurationSection)cfg, "");
        this.prefixRaw = this.messages.getOrDefault("ui.prefix", this.defaultPrefixRaw);
    }

    private String normalize(String locale) {
        if (locale == null || locale.isBlank()) {
            return "en_US";
        }
        String trimmed = locale.trim();
        if (trimmed.endsWith(".yml")) {
            return trimmed.substring(0, trimmed.length() - 4);
        }
        return trimmed;
    }

    private void collectMessages(ConfigurationSection section, String pathPrefix) {
        for (String key : section.getKeys(false)) {
            String fullKey;
            String string = fullKey = pathPrefix.isBlank() ? key : pathPrefix + "." + key;
            if (section.isConfigurationSection(key)) {
                this.collectMessages(section.getConfigurationSection(key), fullKey);
                continue;
            }
            this.messages.put(fullKey, section.getString(key, fullKey));
        }
    }

    public List<String> syncLocaleFile(String locale) {
        return LangLoader.syncLocale(this.plugin, locale);
    }

    public String getLanguage() {
        return this.currentLocale;
    }

    public void setPrefixLabel(String label) {
        this.prefixLabel = label == null || label.isBlank() ? this.defaultPrefixLabel : label;
    }

    private TagResolver prefixResolvers(TagResolver ... extra) {
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolver(Placeholder.parsed("prefix", this.prefixRaw));
        builder.resolver(Placeholder.unparsed("prefix_label", this.prefixLabel));
        if (extra != null) {
            for (TagResolver resolver : extra) {
                if (resolver == null) continue;
                builder.resolver(resolver);
            }
        }
        return builder.build();
    }

    public Component component(String key) {
        String raw = this.messages.getOrDefault(key, key);
        return MINI.deserialize(raw, this.prefixResolvers(new TagResolver[0]));
    }

    public Component format(String key, Map<String, String> replacements) {
        String raw = this.messages.getOrDefault(key, key);
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolver(this.prefixResolvers(new TagResolver[0]));
        if (replacements != null) {
            for (Map.Entry<String, String> e : replacements.entrySet()) {
                builder.resolver(Placeholder.unparsed(e.getKey(), e.getValue()));
            }
        }
        return MINI.deserialize(raw, builder.build());
    }

    public String plain(String key) {
        return PLAIN.serialize(this.component(key));
    }

    public String plain(String key, Map<String, String> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return this.plain(key);
        }
        return PLAIN.serialize(this.format(key, replacements));
    }

    public void reload(FileConfiguration config) {
        String lang = config.getString("language", this.currentLocale);
        this.load(lang);
    }
}

