/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import com.github.hrobasti.turtlelib.helper.VersionComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class ServerMatcher {
    private final JavaPlugin plugin;
    private final Set<String> exactVersions;
    private final List<VersionRange> ranges;
    private final IncompatibleAction action;
    private final Consumer<MatchResult> mismatchConsumer;
    private final String supportedSummary;

    private ServerMatcher(Builder builder) {
        this.plugin = builder.plugin;
        this.exactVersions = Collections.unmodifiableSet(builder.exactVersions);
        this.ranges = Collections.unmodifiableList(builder.ranges);
        this.action = builder.action;
        this.mismatchConsumer = builder.mismatchConsumer;
        this.supportedSummary = builder.describeRules();
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public MatchResult check() {
        String serverName = this.plugin.getServer().getName();
        String mcVersion = Bukkit.getMinecraftVersion();
        boolean supported = this.isSupported(mcVersion);
        String reason = supported ? "" : this.buildReason(mcVersion, serverName);
        return new MatchResult(supported, serverName, mcVersion, this.supportedSummary, reason);
    }

    public MatchResult enforce() {
        MatchResult result = this.check();
        if (result.supported()) {
            return result;
        }
        if (this.mismatchConsumer != null) {
            this.mismatchConsumer.accept(result);
        }
        String detail = "Detected " + result.serverName + " (MC " + result.minecraftVersion + "), supported set: " + this.supportedSummary + ".";
        if (this.action == IncompatibleAction.WARN_AND_CONTINUE) {
            this.plugin.getLogger().warning("[ServerMatcher] " + detail + " Proceeding, but behaviour is unsupported.");
        } else {
            this.plugin.getLogger().severe("[ServerMatcher] " + detail + " Disabling plugin due to incompatible server version.");
            PluginManager pm = Bukkit.getPluginManager();
            pm.disablePlugin((Plugin)this.plugin);
        }
        return result;
    }

    private boolean isSupported(String candidateVersion) {
        if (candidateVersion == null || candidateVersion.isBlank()) {
            return false;
        }
        if (this.exactVersions.isEmpty() && this.ranges.isEmpty()) {
            return true;
        }
        String normalized = candidateVersion.trim();
        if (this.exactVersions.contains(normalized)) {
            return true;
        }
        for (VersionRange range : this.ranges) {
            if (!range.contains(normalized)) continue;
            return true;
        }
        return false;
    }

    private String buildReason(String mcVersion, String serverName) {
        return "Server " + serverName + " (MC " + mcVersion + ") is outside the supported set: " + this.supportedSummary;
    }

    public static final class Builder {
        private final JavaPlugin plugin;
        private final Set<String> exactVersions = new LinkedHashSet<String>();
        private final List<VersionRange> ranges = new ArrayList<VersionRange>();
        private IncompatibleAction action = IncompatibleAction.ERROR_AND_DISABLE;
        private Consumer<MatchResult> mismatchConsumer;

        private Builder(JavaPlugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
        }

        public Builder allowVersion(String version) {
            if (version != null && !version.isBlank()) {
                this.exactVersions.add(version.trim());
            }
            return this;
        }

        public Builder allowVersions(Collection<String> versions) {
            if (versions != null) {
                for (String v : versions) {
                    this.allowVersion(v);
                }
            }
            return this;
        }

        public Builder allowRange(String minInclusive, String maxInclusive) {
            if ((minInclusive == null || minInclusive.isBlank()) && (maxInclusive == null || maxInclusive.isBlank())) {
                return this;
            }
            this.ranges.add(new VersionRange(this.nullIfBlank(minInclusive), this.nullIfBlank(maxInclusive)));
            return this;
        }

        public Builder incompatibleAction(IncompatibleAction action) {
            if (action != null) {
                this.action = action;
            }
            return this;
        }

        public Builder onMismatch(Consumer<MatchResult> consumer) {
            this.mismatchConsumer = consumer;
            return this;
        }

        public ServerMatcher build() {
            return new ServerMatcher(this);
        }

        private String describeRules() {
            if (this.exactVersions.isEmpty() && this.ranges.isEmpty()) {
                return "no constraints";
            }
            StringJoiner joiner = new StringJoiner(", ");
            for (VersionRange range : this.ranges) {
                joiner.add(range.describe());
            }
            for (String version : this.exactVersions) {
                joiner.add(version);
            }
            return joiner.toString();
        }

        private String nullIfBlank(String value) {
            return value == null || value.isBlank() ? null : value.trim();
        }
    }

    public static enum IncompatibleAction {
        WARN_AND_CONTINUE,
        ERROR_AND_DISABLE;

    }

    public static final class MatchResult {
        private final boolean supported;
        private final String serverName;
        private final String minecraftVersion;
        private final String supportedDescription;
        private final String message;

        private MatchResult(boolean supported, String serverName, String minecraftVersion, String supportedDescription, String message) {
            this.supported = supported;
            this.serverName = serverName;
            this.minecraftVersion = minecraftVersion;
            this.supportedDescription = supportedDescription;
            this.message = message;
        }

        public boolean supported() {
            return this.supported;
        }

        public String serverName() {
            return this.serverName;
        }

        public String minecraftVersion() {
            return this.minecraftVersion;
        }

        public String supportedDescription() {
            return this.supportedDescription;
        }

        public String message() {
            return this.message;
        }
    }

    private static final class VersionRange {
        private final String min;
        private final String max;

        private VersionRange(String min, String max) {
            this.min = min;
            this.max = max;
        }

        private boolean contains(String candidate) {
            if (candidate == null) {
                return false;
            }
            if (this.min != null && VersionComparator.compare(candidate, this.min) < 0) {
                return false;
            }
            return this.max == null || VersionComparator.compare(candidate, this.max) <= 0;
        }

        private String describe() {
            if (this.min != null && this.max != null) {
                return this.min + "-" + this.max;
            }
            if (this.min != null) {
                return ">=" + this.min;
            }
            if (this.max != null) {
                return "<=" + this.max;
            }
            return "any";
        }
    }
}

