/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public final class StartupBanner {
    private static final MiniMessage MINI = MiniMessage.miniMessage();
    private final JavaPlugin plugin;
    private final List<String> lines;
    private final String colorTag;

    private StartupBanner(JavaPlugin plugin, List<String> lines, String colorTag) {
        this.plugin = plugin;
        this.lines = lines == null ? List.of() : List.copyOf(lines);
        this.colorTag = colorTag == null || colorTag.isBlank() ? "<white>" : colorTag.trim();
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public void send() {
        if (this.lines.isEmpty()) {
            return;
        }
        ConsoleCommandSender console = this.plugin.getServer().getConsoleSender();
        if (console == null) {
            return;
        }
        for (String rawLine : this.lines) {
            String escaped = MINI.escapeTags(rawLine == null ? "" : rawLine);
            console.sendMessage(MINI.deserialize(this.colorTag + escaped + "<reset>"));
        }
    }

    public static final class Builder {
        private final JavaPlugin plugin;
        private final List<String> manualLines = new ArrayList<String>();
        private String resourcePath;
        private String colorTag = "<light_purple>";

        private Builder(JavaPlugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
        }

        public Builder addLine(String line) {
            if (line != null) {
                this.manualLines.add(line);
            }
            return this;
        }

        public Builder lines(List<String> lines) {
            this.manualLines.clear();
            if (lines != null) {
                this.manualLines.addAll(lines);
            }
            return this;
        }

        public Builder resource(String relativePath) {
            this.resourcePath = relativePath;
            return this;
        }

        public Builder color(String miniMessageColorTag) {
            if (miniMessageColorTag != null && !miniMessageColorTag.isBlank()) {
                this.colorTag = miniMessageColorTag.trim();
            }
            return this;
        }

        public StartupBanner build() {
            ArrayList<String> resolved = new ArrayList<String>();
            resolved.addAll(this.loadResourceLines());
            resolved.addAll(this.manualLines);
            return new StartupBanner(this.plugin, resolved, this.colorTag);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private List<String> loadResourceLines() {
            if (this.resourcePath == null || this.resourcePath.isBlank()) {
                return Collections.emptyList();
            }
            try (InputStream in = this.plugin.getResource(this.resourcePath);){
                ArrayList<String> arrayList;
                if (in == null) {
                    this.plugin.getLogger().fine("StartupBanner resource not found: " + this.resourcePath);
                    List<String> list = Collections.emptyList();
                    return list;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    String line;
                    ArrayList<String> result = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        result.add(line);
                    }
                    arrayList = result;
                }
                return arrayList;
            }
            catch (IOException ex) {
                this.plugin.getLogger().fine("Failed to read banner resource: " + ex.getMessage());
                return Collections.emptyList();
            }
        }
    }
}

