/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import com.github.hrobasti.turtlelib.helper.VersionComparator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final Plugin plugin;
    private final int providerMode;
    private final boolean includePrereleases;
    private final boolean filterByServerVersion;
    private final String modrinthSlug;
    private final String hangarNamespace;
    private final String userAgent;
    private final String minecraftVersion;
    private final String minecraftVersionLower;
    private final String minecraftVersionPrefix;
    private final String minecraftVersionPrefixLower;

    public UpdateChecker(Plugin plugin, int providerMode, boolean includePrereleases, String modrinthSlug, String hangarNamespace) {
        this(plugin, providerMode, includePrereleases, false, modrinthSlug, hangarNamespace);
    }

    public UpdateChecker(Plugin plugin, int providerMode, boolean includePrereleases, boolean filterByServerVersion, String modrinthSlug, String hangarNamespace) {
        String mcVersion;
        this.plugin = plugin;
        this.providerMode = providerMode;
        this.includePrereleases = includePrereleases;
        this.filterByServerVersion = filterByServerVersion;
        this.modrinthSlug = modrinthSlug;
        this.hangarNamespace = hangarNamespace;
        this.userAgent = plugin.getPluginMeta().getName() + "-UpdateChecker";
        this.minecraftVersion = mcVersion = filterByServerVersion ? this.normalizeMinecraftVersion(this.safeMinecraftVersion()) : null;
        this.minecraftVersionLower = mcVersion == null ? null : mcVersion.toLowerCase(Locale.ROOT);
        this.minecraftVersionPrefix = mcVersion == null ? null : this.deriveMinorPrefix(mcVersion);
        this.minecraftVersionPrefixLower = this.minecraftVersionPrefix == null ? null : this.minecraftVersionPrefix.toLowerCase(Locale.ROOT);
    }

    public CompletableFuture<UpdateInfo> checkAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String current = this.plugin.getPluginMeta().getVersion();
                ArrayList<ProviderResult> providers = new ArrayList<ProviderResult>();
                if (this.providerMode == 0 || this.providerMode == 1) {
                    providers.add(this.fetchModrinthStatus());
                }
                if (this.providerMode == 0 || this.providerMode == 2) {
                    providers.add(this.fetchHangarStatus());
                }
                String latest = this.findNewestAvailableVersion(current, providers);
                return new UpdateInfo(current, latest, providers);
            }
            catch (Throwable t) {
                this.plugin.getLogger().fine("Update check failed: " + t.getMessage());
                return new UpdateInfo(this.plugin.getPluginMeta().getVersion(), null, List.of());
            }
        });
    }

    private ProviderResult fetchModrinthStatus() {
        try {
            JsonObject version = this.latestFromModrinth();
            if (version == null || !version.has("version_number")) {
                return this.errorResult(Provider.MODRINTH, "Fehler beim Abruf");
            }
            String latest = version.get("version_number").getAsString();
            return new ProviderResult(Provider.MODRINTH, latest, this.providerBaseUrl(Provider.MODRINTH), null, version);
        }
        catch (Exception ex) {
            this.plugin.getLogger().fine("Modrinth update check failed: " + ex.getMessage());
            return this.errorResult(Provider.MODRINTH, "Fehler beim Abruf");
        }
    }

    private ProviderResult fetchHangarStatus() {
        try {
            JsonObject version = this.latestFromHangar();
            if (version == null || !version.has("name")) {
                return this.errorResult(Provider.HANGAR, "Fehler beim Abruf");
            }
            String latest = version.get("name").getAsString();
            return new ProviderResult(Provider.HANGAR, latest, this.providerBaseUrl(Provider.HANGAR), null, version);
        }
        catch (Exception ex) {
            this.plugin.getLogger().fine("Hangar update check failed: " + ex.getMessage());
            return this.errorResult(Provider.HANGAR, "Fehler beim Abruf");
        }
    }

    private ProviderResult errorResult(Provider provider, String message) {
        return new ProviderResult(provider, null, this.providerBaseUrl(provider), message, null);
    }

    private String findNewestAvailableVersion(String current, List<ProviderResult> providers) {
        String latest = null;
        for (ProviderResult result : providers) {
            String candidate = result.latestVersion();
            if (candidate == null || !VersionComparator.isGreater(candidate, current) || latest != null && !VersionComparator.isGreater(candidate, latest)) continue;
            latest = candidate;
        }
        return latest;
    }

    private JsonObject latestFromModrinth() throws Exception {
        block10: {
            if (this.modrinthSlug == null || this.modrinthSlug.isBlank()) {
                throw new IllegalStateException("No Modrinth slug configured");
            }
            URL url = URI.create("https://api.modrinth.com/v2/project/" + this.modrinthSlug + "/version").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", this.userAgent);
            if (conn.getResponseCode() != 200) {
                throw new IllegalStateException("HTTP " + conn.getResponseCode());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                JsonElement el = JsonParser.parseString(sb.toString());
                if (!el.isJsonArray()) break block10;
                JsonArray arr = el.getAsJsonArray();
                for (JsonElement entry : arr) {
                    if (!entry.isJsonObject()) continue;
                    JsonObject version = entry.getAsJsonObject();
                    if (!this.includePrereleases && this.isModrinthPrerelease(version) || !this.matchesServerVersion(version, Provider.MODRINTH)) continue;
                    if (!version.has("version_number")) continue;
                    JsonObject jsonObject = version;
                    return jsonObject;
                }
            }
        }
        throw new IllegalStateException("No versions found");
    }

    private JsonObject latestFromHangar() throws Exception {
        block13: {
            if (this.hangarNamespace == null || this.hangarNamespace.isBlank()) {
                throw new IllegalStateException("No Hangar namespace configured");
            }
            URL url = URI.create("https://hangar.papermc.io/api/v1/projects/" + this.hangarNamespace + "/versions").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", this.userAgent);
            if (conn.getResponseCode() != 200) {
                throw new IllegalStateException("HTTP " + conn.getResponseCode());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                JsonElement res;
                JsonObject obj;
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                JsonElement el = JsonParser.parseString(sb.toString());
                if (el.isJsonArray()) {
                    JsonArray arr = el.getAsJsonArray();
                    for (JsonElement entry : arr) {
                        if (!entry.isJsonObject()) continue;
                        JsonObject version = entry.getAsJsonObject();
                        if (!this.includePrereleases && this.isHangarPrerelease(version) || !this.matchesServerVersion(version, Provider.HANGAR)) continue;
                        if (!version.has("name")) continue;
                        JsonObject jsonObject = version;
                        return jsonObject;
                    }
                    break block13;
                }
                if (!el.isJsonObject() || !(obj = el.getAsJsonObject()).has("result") || !(res = obj.get("result")).isJsonArray()) break block13;
                JsonArray arr = res.getAsJsonArray();
                for (JsonElement entry : arr) {
                    if (!entry.isJsonObject()) continue;
                    JsonObject version = entry.getAsJsonObject();
                    if (!this.includePrereleases && this.isHangarPrerelease(version) || !this.matchesServerVersion(version, Provider.HANGAR)) continue;
                    if (!version.has("name")) continue;
                    JsonObject jsonObject = version;
                    return jsonObject;
                }
            }
        }
        throw new IllegalStateException("No versions found");
    }

    private String providerBaseUrl(Provider provider) {
        return switch (provider.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.modrinthSlug == null || this.modrinthSlug.isBlank()) {
                    yield "https://modrinth.com";
                }
                yield "https://modrinth.com/plugin/" + this.modrinthSlug;
            }
            case 1 -> this.hangarNamespace == null || this.hangarNamespace.isBlank() ? "https://hangar.papermc.io" : "https://hangar.papermc.io/" + this.hangarNamespace;
        };
    }

    private boolean isModrinthPrerelease(JsonObject version) {
        if (version.has("prerelease") && version.get("prerelease").isJsonPrimitive()) {
            try {
                if (version.get("prerelease").getAsBoolean()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version.has("version_type") && version.get("version_type").isJsonPrimitive()) {
            String type = version.get("version_type").getAsString();
            return !"release".equalsIgnoreCase(type);
        }
        return false;
    }

    private boolean isHangarPrerelease(JsonObject version) {
        if (version.has("channel")) {
            JsonElement channelEl = version.get("channel");
            String channelName = null;
            if (channelEl.isJsonObject()) {
                JsonObject channelObj = channelEl.getAsJsonObject();
                if (channelObj.has("name")) {
                    channelName = channelObj.get("name").getAsString();
                }
            } else if (channelEl.isJsonPrimitive()) {
                channelName = channelEl.getAsString();
            }
            if (channelName != null) {
                return !"release".equalsIgnoreCase(channelName);
            }
        }
        if (version.has("visibility") && version.get("visibility").isJsonPrimitive()) {
            return false;
        }
        return false;
    }

    private boolean matchesServerVersion(JsonObject version, Provider provider) {
        boolean matched;
        if (!this.filterByServerVersion || this.minecraftVersionLower == null) {
            return true;
        }
        switch (provider.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean bl = this.matchesModrinthVersions(version);
                break;
            }
            case 1: {
                boolean bl = matched = this.matchesHangarVersions(version);
            }
        }
        if (matched) {
            return true;
        }
        String raw = version.toString();
        return this.fallbackMatches(raw);
    }

    private boolean matchesModrinthVersions(JsonObject version) {
        JsonElement versions = version.get("game_versions");
        if (versions != null && versions.isJsonArray()) {
            JsonArray arr = versions.getAsJsonArray();
            for (JsonElement entry : arr) {
                if (!entry.isJsonPrimitive() || !this.matchesVersionToken(entry.getAsString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesHangarVersions(JsonObject version) {
        JsonElement mcVersions;
        JsonElement deps = version.get("platformDependencies");
        if (deps != null) {
            if (deps.isJsonArray()) {
                for (JsonElement entry : deps.getAsJsonArray()) {
                    if (!entry.isJsonObject() || !this.matchesHangarDependency(entry.getAsJsonObject())) continue;
                    return true;
                }
            } else if (deps.isJsonObject() && this.matchesHangarDependency(deps.getAsJsonObject())) {
                return true;
            }
        }
        if ((mcVersions = version.get("minecraft_versions")) != null && mcVersions.isJsonArray()) {
            for (JsonElement entry : mcVersions.getAsJsonArray()) {
                if (!entry.isJsonPrimitive() || !this.matchesVersionToken(entry.getAsString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesHangarDependency(JsonObject dependency) {
        if (dependency == null) {
            return false;
        }
        if (dependency.has("required") && dependency.get("required").isJsonArray() && this.matchesVersionArray(dependency.get("required").getAsJsonArray())) {
            return true;
        }
        if (dependency.has("compatible") && dependency.get("compatible").isJsonArray() && this.matchesVersionArray(dependency.get("compatible").getAsJsonArray())) {
            return true;
        }
        if (dependency.has("versions") && dependency.get("versions").isJsonArray()) {
            return this.matchesVersionArray(dependency.get("versions").getAsJsonArray());
        }
        return false;
    }

    private boolean matchesVersionArray(JsonArray array) {
        for (JsonElement element : array) {
            if (!element.isJsonPrimitive() || !this.matchesVersionToken(element.getAsString())) continue;
            return true;
        }
        return false;
    }

    private boolean matchesVersionToken(String value) {
        if (value == null || this.minecraftVersionLower == null) {
            return false;
        }
        String normalized = value.trim();
        if (normalized.isEmpty()) {
            return false;
        }
        if ((normalized = normalized.replace("\"", "")).isEmpty()) {
            return false;
        }
        String lower = normalized.toLowerCase(Locale.ROOT);
        if (lower.equals(this.minecraftVersionLower)) {
            return true;
        }
        if (this.minecraftVersionPrefixLower != null) {
            if (lower.equals(this.minecraftVersionPrefixLower)) {
                return true;
            }
            if (lower.startsWith(this.minecraftVersionPrefixLower + ".")) {
                return true;
            }
            if (lower.equals(this.minecraftVersionPrefixLower + ".x") || lower.equals(this.minecraftVersionPrefixLower + "x")) {
                return true;
            }
        }
        return false;
    }

    private boolean fallbackMatches(String raw) {
        if (raw == null || this.minecraftVersion == null) {
            return false;
        }
        if (raw.contains("\"" + this.minecraftVersion + "\"")) {
            return true;
        }
        if (raw.contains(this.minecraftVersion)) {
            return true;
        }
        if (this.minecraftVersionPrefix != null) {
            if (raw.contains("\"" + this.minecraftVersionPrefix + "\"")) {
                return true;
            }
            if (raw.contains("\"" + this.minecraftVersionPrefix + ".")) {
                return true;
            }
        }
        return false;
    }

    private String safeMinecraftVersion() {
        try {
            return Bukkit.getMinecraftVersion();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private String normalizeMinecraftVersion(String version) {
        if (version == null) {
            return null;
        }
        int dash = version.indexOf(45);
        if (dash > 0) {
            version = version.substring(0, dash);
        }
        return version.trim();
    }

    private String deriveMinorPrefix(String version) {
        if (version == null) {
            return null;
        }
        String[] parts = version.split("\\.");
        if (parts.length >= 2) {
            return parts[0] + "." + parts[1];
        }
        return version;
    }

    public static enum Provider {
        MODRINTH("Modrinth"),
        HANGAR("Hangar");

        private final String displayName;

        private Provider(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }
    }

    public record ProviderResult(Provider provider, String latestVersion, String url, String errorMessage, JsonObject metadata) {
        public boolean success() {
            return this.errorMessage == null;
        }
    }

    public record UpdateInfo(String currentVersion, String latestVersion, List<ProviderResult> providers) {
        public boolean hasUpdate() {
            return this.latestVersion != null && !this.latestVersion.isBlank();
        }
    }
}

