/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.turtlelib.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class VersionComparator {
    private VersionComparator() {
    }

    public static int compare(String a, String b) {
        Version va = Version.parse(a);
        Version vb = Version.parse(b);
        return va.compareTo(vb);
    }

    public static boolean isGreater(String a, String b) {
        return VersionComparator.compare(a, b) > 0;
    }

    static final class Version
    implements Comparable<Version> {
        final List<Integer> nums;
        final String letterSuffix;
        final Pre pre;

        Version(List<Integer> nums, String letterSuffix, Pre pre) {
            this.nums = nums;
            this.letterSuffix = letterSuffix;
            this.pre = pre;
        }

        static Version parse(String s) {
            String lower;
            if (s == null) {
                s = "";
            }
            String raw = s.trim();
            String main = lower = raw.toLowerCase(Locale.ROOT);
            String pre = null;
            int dash = lower.indexOf(45);
            if (dash >= 0) {
                main = lower.substring(0, dash);
                pre = lower.substring(dash + 1);
            }
            String[] segs = main.split("\\.");
            ArrayList<Integer> nums = new ArrayList<Integer>();
            String letterSuffix = null;
            for (int i = 0; i < segs.length; ++i) {
                String tail;
                int val;
                int j;
                String seg = segs[i];
                if (seg.isEmpty()) {
                    nums.add(0);
                    continue;
                }
                for (j = 0; j < seg.length() && Character.isDigit(seg.charAt(j)); ++j) {
                }
                String numStr = j > 0 ? seg.substring(0, j) : "0";
                try {
                    val = Integer.parseInt(numStr);
                }
                catch (Exception e) {
                    val = 0;
                }
                nums.add(val);
                if (i != segs.length - 1 || (tail = seg.substring(j)).isEmpty() || !Version.allLetters(tail)) continue;
                letterSuffix = tail;
            }
            if (nums.isEmpty()) {
                nums.add(0);
            }
            Pre preObj = Pre.parse(pre);
            return new Version(nums, letterSuffix, preObj);
        }

        static boolean allLetters(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isLetter(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(Version o) {
            int c;
            boolean bHas;
            int max = Math.max(this.nums.size(), o.nums.size());
            for (int i = 0; i < max; ++i) {
                int b;
                int a = i < this.nums.size() ? this.nums.get(i) : 0;
                int n = b = i < o.nums.size() ? o.nums.get(i) : 0;
                if (a == b) continue;
                return Integer.compare(a, b);
            }
            boolean aHas = this.letterSuffix != null && !this.letterSuffix.isEmpty();
            boolean bl = bHas = o.letterSuffix != null && !o.letterSuffix.isEmpty();
            if (aHas && !bHas) {
                return 1;
            }
            if (!aHas && bHas) {
                return -1;
            }
            if (aHas && bHas && (c = this.letterSuffix.compareTo(o.letterSuffix)) != 0) {
                return c;
            }
            if (this.pre == null && o.pre != null) {
                return 1;
            }
            if (this.pre != null && o.pre == null) {
                return -1;
            }
            if (this.pre == null) {
                return 0;
            }
            return this.pre.compareTo(o.pre);
        }

        static final class Pre
        implements Comparable<Pre> {
            final String label;
            final int number;

            Pre(String label, int number) {
                this.label = label;
                this.number = number;
            }

            static Pre parse(String s) {
                int i;
                if (s == null || s.isEmpty()) {
                    return null;
                }
                String t = s.trim().toLowerCase(Locale.ROOT);
                for (i = 0; i < t.length() && Character.isLetter(t.charAt(i)); ++i) {
                }
                String name = i > 0 ? t.substring(0, i) : t;
                String numStr = i < t.length() ? t.substring(i) : "";
                int n = 0;
                try {
                    if (!numStr.isEmpty()) {
                        n = Integer.parseInt(numStr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new Pre(name, n);
            }

            static int rank(String name) {
                if (name == null) {
                    return -1;
                }
                switch (name) {
                    case "alpha": {
                        return 0;
                    }
                    case "beta": {
                        return 1;
                    }
                    case "rc": {
                        return 2;
                    }
                }
                return -1;
            }

            @Override
            public int compareTo(Pre o) {
                int rb;
                if (Objects.equals(this.label, o.label)) {
                    return Integer.compare(this.number, o.number);
                }
                int ra = Pre.rank(this.label);
                if (ra != (rb = Pre.rank(o.label))) {
                    return Integer.compare(ra, rb);
                }
                return this.label.compareTo(o.label);
            }
        }
    }
}

