/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.underwatertrees;

import com.github.hrobasti.turtlelib.helper.ConfigWatcher;
import com.github.hrobasti.turtlelib.helper.MessageService;
import com.github.hrobasti.turtlelib.helper.ServerMatcher;
import com.github.hrobasti.turtlelib.helper.StartupBanner;
import com.github.hrobasti.turtlelib.helper.UpdateChecker;
import com.github.hrobasti.turtlelib.helper.VersionComparator;
import com.github.hrobasti.underwatertrees.commands.UnderwaterTreesBasicCommand;
import com.github.hrobasti.underwatertrees.listeners.UnderwaterSaplingsListener;
import com.github.hrobasti.underwatertrees.metrics.Metrics;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UnderwaterTreesPlugin
extends JavaPlugin {
    private static final String STARTUP_BANNER_RESOURCE = "banner.txt";
    private static final String SUPPORTED_SERVER_BRAND = "Paper";
    private static final String SUPPORTED_VERSION_MIN = "1.21";
    private static final String SUPPORTED_VERSION_MAX = "1.21.10";
    private static final String SUPPORTED_VERSION_LABEL = "1.21 - 1.21.10";
    private UnderwaterSaplingsListener saplingsListener;
    private MessageService messages;
    private ConfigWatcher configWatcher;
    private Metrics metrics;
    private UpdateChecker updateChecker;
    private int updateTaskId = -1;
    private volatile UpdateChecker.UpdateInfo latestUpdateInfo;
    private volatile UpdateChecker.ProviderResult preferredUpdateResult;
    private volatile boolean announceNextUpdateSummary = true;
    private Listener updateJoinListener;
    private ServerMatcher serverMatcher;

    public void onEnable() {
        this.saveDefaultConfig();
        this.ensureConfigDefaults();
        if (this.getConfig().getBoolean("startup-banner-enabled", true)) {
            this.logStartupBanner();
        }
        String lang = this.getConfig().getString("language", "en_US");
        this.messages = new MessageService(this, "<green>[<prefix_label>]</green>", "UnderwaterTrees");
        this.messages.load(lang);
        this.applyChatPrefixLabel();
        this.setupServerMatcher();
        this.getLogger().info(this.messages.plain("plugin.language-set", Map.of("code", this.messages.getLanguage())));
        this.saplingsListener = new UnderwaterSaplingsListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.saplingsListener, (Plugin)this);
        this.registerCommand("underwatertrees", new UnderwaterTreesBasicCommand(this, this.saplingsListener));
        this.getLogger().info(this.messages.plain("plugin.enabled"));
        this.initMetrics();
        this.initUpdateChecker();
        this.initializeConfigWatcher();
        if (this.configWatcher != null) {
            this.configWatcher.start();
        }
    }

    public void onDisable() {
        if (this.configWatcher != null) {
            this.configWatcher.stop();
        }
        this.stopUpdateCheck();
        if (this.messages == null) {
            this.getLogger().info("UnderwaterTrees plugin disabled.");
        } else {
            this.getLogger().info(this.messages.plain("plugin.disabled"));
        }
    }

    public MessageService getMessages() {
        return this.messages;
    }

    public void reloadMessages() {
        if (this.messages == null) {
            this.messages = new MessageService(this, "<green>[<prefix_label>]</green>", "UnderwaterTrees");
        }
        this.messages.reload(this.getConfig());
        this.applyChatPrefixLabel();
        this.setupServerMatcher();
        this.getLogger().info(this.messages.plain("plugin.language-set", Map.of("code", this.messages.getLanguage())));
        this.initMetrics();
        this.initUpdateChecker();
        this.refreshConfigWatcherBaseline();
    }

    private void initMetrics() {
        boolean enabled = this.getConfig().getBoolean("metrics-enabled", true);
        if (enabled) {
            if (this.metrics == null) {
                this.metrics = new Metrics((Plugin)this, 28005);
                this.metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.messages.getLanguage()));
                this.metrics.addCustomChart(new Metrics.SingleLineChart("sapling_count", this.saplingsListener::getSaplingCount));
                this.metrics.addCustomChart(new Metrics.SingleLineChart("soil_block_count", this.saplingsListener::getSoilCount));
            }
        } else if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
        }
    }

    private void logStartupBanner() {
        StartupBanner.builder(this).resource(STARTUP_BANNER_RESOURCE).color("<green>").build().send();
    }

    private void setupServerMatcher() {
        if (this.messages == null) {
            this.serverMatcher = null;
            return;
        }
        this.serverMatcher = ServerMatcher.builder(this).allowRange(SUPPORTED_VERSION_MIN, SUPPORTED_VERSION_MAX).incompatibleAction(ServerMatcher.IncompatibleAction.WARN_AND_CONTINUE).onMismatch(this::handleServerMismatch).build();
        this.serverMatcher.enforce();
    }

    private void handleServerMismatch(ServerMatcher.MatchResult result) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("required_server", SUPPORTED_SERVER_BRAND);
        placeholders.put("supported_versions", SUPPORTED_VERSION_LABEL);
        placeholders.put("server_name", result.serverName() != null ? result.serverName() : "unknown");
        placeholders.put("mc_version", result.minecraftVersion() != null ? result.minecraftVersion() : "unknown");
        if (this.messages != null) {
            ConsoleCommandSender console = this.getServer().getConsoleSender();
            if (console != null) {
                console.sendMessage(this.messages.format("warn.unsupported-server-version", placeholders));
            }
            this.getLogger().warning(this.messages.plain("warn.unsupported-server-version", placeholders));
        } else {
            this.getLogger().warning("UnderwaterTrees officially supports Paper 1.21 - 1.21.10. Detected " + result.serverName() + " " + result.minecraftVersion() + ".");
        }
    }

    private void initUpdateChecker() {
        boolean enabled = this.readUpdateBoolean("enabled", true);
        if (!enabled) {
            this.stopUpdateCheck();
            return;
        }
        int providerMode = Math.max(0, Math.min(2, this.readUpdateInt("sources", 0)));
        boolean includePrereleases = this.readUpdateBoolean("include-prereleases", false);
        boolean filterByServerVersion = this.readUpdateBoolean("filter-by-server-version", true);
        this.updateChecker = new UpdateChecker((Plugin)this, providerMode, includePrereleases, filterByServerVersion, "underwatertrees", "hro_basti/underwatertrees");
        this.announceNextUpdateSummary = true;
        this.registerUpdateNotifier();
        this.requestUpdateCheck(true);
        long hours = Math.max(1L, this.readUpdateLong("interval-hours", 24L));
        long periodTicks = hours * 60L * 60L * 20L;
        if (this.updateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.updateTaskId);
        }
        this.updateTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.requestUpdateCheck(false), periodTicks, periodTicks).getTaskId();
    }

    private void stopUpdateCheck() {
        if (this.updateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.updateTaskId);
            this.updateTaskId = -1;
        }
        this.updateChecker = null;
        this.latestUpdateInfo = null;
        this.preferredUpdateResult = null;
        this.announceNextUpdateSummary = true;
    }

    private void requestUpdateCheck(boolean logConsole) {
        if (this.updateChecker == null) {
            return;
        }
        ((CompletableFuture)this.updateChecker.checkAsync().thenAccept(info -> {
            if (!this.isEnabled()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.handleUpdateInfo((UpdateChecker.UpdateInfo)info, logConsole));
        })).exceptionally(ex -> {
            this.getLogger().fine("Update check failed: " + ex.getMessage());
            return null;
        });
    }

    private void handleUpdateInfo(UpdateChecker.UpdateInfo info, boolean logConsole) {
        boolean wantsLog;
        UpdateChecker.ProviderResult chosen;
        if (info == null) {
            return;
        }
        this.latestUpdateInfo = info;
        this.preferredUpdateResult = chosen = this.selectPreferredProvider(info);
        boolean notifyConsole = this.readUpdateBoolean("notify-console", true);
        boolean alwaysShow = this.readUpdateBoolean("notify-console-always-shown", false);
        boolean bl = wantsLog = notifyConsole && (this.announceNextUpdateSummary || logConsole || info.hasUpdate());
        if (wantsLog && (info.hasUpdate() || alwaysShow)) {
            this.logUpdateSummary(info);
            this.announceNextUpdateSummary = false;
        }
        if (!info.hasUpdate() || !notifyConsole || chosen == null) {
            return;
        }
    }

    private UpdateChecker.ProviderResult selectPreferredProvider(UpdateChecker.UpdateInfo info) {
        if (info.providers() == null) {
            return null;
        }
        UpdateChecker.ProviderResult selected = null;
        for (UpdateChecker.ProviderResult result : info.providers()) {
            String remote;
            if (result == null || !result.success() || (remote = result.latestVersion()) == null || !VersionComparator.isGreater(remote, info.currentVersion()) || selected != null && !VersionComparator.isGreater(remote, selected.latestVersion())) continue;
            selected = result;
        }
        return selected;
    }

    private void registerUpdateNotifier() {
        if (this.updateJoinListener != null) {
            return;
        }
        this.updateJoinListener = new Listener(){

            @EventHandler
            public void onJoin(PlayerJoinEvent event) {
                UnderwaterTreesPlugin.this.notifyPlayerAboutUpdate(event.getPlayer());
            }
        };
        Bukkit.getPluginManager().registerEvents(this.updateJoinListener, (Plugin)this);
    }

    private void notifyPlayerAboutUpdate(Player player) {
        if (!this.readUpdateBoolean("notify-op-join", true)) {
            return;
        }
        UpdateChecker.ProviderResult result = this.preferredUpdateResult;
        UpdateChecker.UpdateInfo info = this.latestUpdateInfo;
        if (result == null || info == null) {
            return;
        }
        if (!VersionComparator.isGreater(result.latestVersion(), info.currentVersion())) {
            return;
        }
        if (!player.isOp() && !player.hasPermission("underwatertrees.update.notify")) {
            return;
        }
        String localVersion = this.getPluginMeta().getVersion();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("remote", result.latestVersion());
        placeholders.put("local", localVersion);
        player.sendMessage(this.messages.format("update.available", placeholders));
        player.sendMessage(this.messages.component("update.details"));
    }

    private void applyChatPrefixLabel() {
        if (this.messages == null) {
            return;
        }
        this.messages.setPrefixLabel(this.resolveChatPrefixLabel());
    }

    private String resolveChatPrefixLabel() {
        String label = this.getConfig().getString("chat-prefix-label", "UnderwaterTrees");
        if (label == null || label.isBlank()) {
            return "UnderwaterTrees";
        }
        return label;
    }

    private void initializeConfigWatcher() {
        if (this.configWatcher != null) {
            return;
        }
        this.configWatcher = ConfigWatcher.builder(this).fileSupplier(() -> new File(this.getDataFolder(), "config.yml")).enabledSupplier(() -> this.getConfig().getBoolean("config-watch-enabled", true)).intervalSeconds(this.resolveConfigWatchIntervalSeconds()).onChange(this::handleExternalConfigChange).build();
    }

    private long resolveConfigWatchIntervalSeconds() {
        long configured = this.getConfig().getLong("config-watch-interval-seconds", 5L);
        return Math.max(1L, configured);
    }

    private void handleExternalConfigChange() {
        try {
            this.reloadConfig();
            this.ensureConfigDefaults();
            if (this.saplingsListener != null) {
                this.saplingsListener.applyConfig(this.getConfig());
            }
            this.reloadMessages();
            this.getLogger().info("Config file changed externally \u2013 auto reloaded.");
        }
        catch (Exception ex) {
            this.getLogger().warning("Error during automatic config reload: " + ex.getMessage());
        }
    }

    private void refreshConfigWatcherBaseline() {
        if (this.configWatcher != null) {
            this.configWatcher.refreshBaseline();
        }
    }

    public void ensureConfigDefaults() {
        try (InputStream in = this.getResource("config.yml");){
            if (in == null) {
                return;
            }
            YamlConfiguration def = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            FileConfiguration cfg = this.getConfig();
            cfg.setDefaults((Configuration)def);
            cfg.options().copyDefaults(true);
            this.saveConfig();
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to merge default config: " + ex.getMessage());
        }
    }

    private void logUpdateSummary(UpdateChecker.UpdateInfo info) {
        boolean shouldBracketLog;
        List<Object> providers = info.providers() == null ? Collections.emptyList() : info.providers();
        boolean hasProviderDetails = !providers.isEmpty();
        boolean bl = shouldBracketLog = info.hasUpdate() || hasProviderDetails;
        if (shouldBracketLog) {
            this.logUpdateDivider();
        }
        if (info.hasUpdate()) {
            this.getLogger().info("Update found. Current version: " + info.currentVersion() + ".");
        } else {
            this.getLogger().info("No update found.");
        }
        if (hasProviderDetails) {
            for (UpdateChecker.ProviderResult providerResult : providers) {
                this.logProviderResult(providerResult);
            }
        }
        if (shouldBracketLog) {
            this.logUpdateDivider();
        }
    }

    private void logUpdateDivider() {
        this.getLogger().info("=======================");
    }

    private void logProviderResult(UpdateChecker.ProviderResult result) {
        if (result == null) {
            return;
        }
        if (!result.success()) {
            this.getLogger().info("- " + result.provider().displayName() + ": Failed to fetch.");
            return;
        }
        String url = result.url() == null ? "" : result.url();
        this.getLogger().info("- " + result.provider().displayName() + ": Version " + result.latestVersion() + " [" + url + "]");
    }

    private ConfigurationSection updateSettings() {
        return this.getConfig().getConfigurationSection("update-check");
    }

    private boolean readUpdateBoolean(String childKey, boolean defaultValue) {
        ConfigurationSection section = this.updateSettings();
        if (section != null && section.contains(childKey)) {
            return section.getBoolean(childKey, defaultValue);
        }
        return defaultValue;
    }

    private int readUpdateInt(String childKey, int defaultValue) {
        ConfigurationSection section = this.updateSettings();
        if (section != null && section.contains(childKey)) {
            return section.getInt(childKey, defaultValue);
        }
        return defaultValue;
    }

    private long readUpdateLong(String childKey, long defaultValue) {
        ConfigurationSection section = this.updateSettings();
        if (section != null && section.contains(childKey)) {
            return section.getLong(childKey, defaultValue);
        }
        return defaultValue;
    }
}

