/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.underwatertrees.commands;

import com.github.hrobasti.turtlelib.helper.MessageService;
import com.github.hrobasti.underwatertrees.UnderwaterTreesPlugin;
import com.github.hrobasti.underwatertrees.listeners.UnderwaterSaplingsListener;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UnderwaterTreesBasicCommand
implements BasicCommand {
    private final UnderwaterTreesPlugin plugin;
    private final UnderwaterSaplingsListener listener;

    public UnderwaterTreesBasicCommand(UnderwaterTreesPlugin plugin, UnderwaterSaplingsListener listener) {
        this.plugin = plugin;
        this.listener = listener;
    }

    public void execute(CommandSourceStack source, String[] args) {
        MessageService msg = this.plugin.getMessages();
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!source.getSender().hasPermission("underwatertrees.admin")) {
                source.getSender().sendMessage(msg.component("command.no-permission"));
                return;
            }
            this.plugin.reloadConfig();
            this.plugin.ensureConfigDefaults();
            this.listener.applyConfig(this.plugin.getConfig());
            this.plugin.reloadMessages();
            MessageService msg2 = this.plugin.getMessages();
            source.getSender().sendMessage(msg2.component("command.reloaded"));
            return;
        }
        source.getSender().sendMessage(msg.format("command.usage", Map.of("label", "underwatertrees")));
    }

    public List<String> suggest(CommandSourceStack source, String[] args) {
        if (args.length == 1 && source.getSender().hasPermission("underwatertrees.admin")) {
            String prefix = args[0].toLowerCase(Locale.ROOT);
            return "reload".startsWith(prefix) ? Collections.singletonList("reload") : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Nullable
    public String permission() {
        return "underwatertrees.admin";
    }
}

