/*
 * Decompiled with CFR 0.152.
 */
package com.github.hrobasti.underwatertrees.listeners;

import com.github.hrobasti.underwatertrees.UnderwaterTreesPlugin;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class UnderwaterSaplingsListener
implements Listener {
    private final UnderwaterTreesPlugin plugin;
    private final Set<Material> saplings = EnumSet.noneOf(Material.class);
    private final Set<Material> validSoils = new HashSet<Material>();
    private final Set<BlockCoordinate> trackedSaplings = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int VANILLA_GROWTH_LIGHT_LEVEL = 10;
    private static final long DEFAULT_GROWTH_TASK_PERIOD_TICKS = 100L;
    private static final int MAX_GROWTH_ATTEMPTS_PER_CYCLE = 64;
    private static final double DEFAULT_GROWTH_ATTEMPT_CHANCE = 0.15;
    private boolean requireWaterAbove = true;
    private boolean protectSaplings = true;
    private boolean growthLightOverrideEnabled = true;
    private int growthMinimumLightLevel = 1;
    private long growthTaskPeriodTicks = 100L;
    private double growthAttemptChance = 0.15;
    private BukkitTask growthTask;

    public UnderwaterSaplingsListener(UnderwaterTreesPlugin plugin) {
        this.plugin = plugin;
        this.applyConfig(plugin.getConfig());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFluidFlow(BlockFromToEvent event) {
        if (!this.protectSaplings) {
            return;
        }
        Block to = event.getToBlock();
        if (this.saplings.contains(to.getType())) {
            event.setCancelled(true);
        }
    }

    public void applyConfig(FileConfiguration cfg) {
        ConfigurationSection growthSection;
        this.saplings.clear();
        this.validSoils.clear();
        this.requireWaterAbove = cfg.getBoolean("require-water-above", false);
        this.protectSaplings = cfg.getBoolean("protect-underwater-saplings", true);
        boolean logStats = cfg.getBoolean("log-stats", true);
        boolean logDetail = cfg.getBoolean("log-detail", false);
        ConfigurationSection saplingSection = cfg.getConfigurationSection("saplings");
        if (saplingSection != null) {
            for (Object key : saplingSection.getKeys(false)) {
                boolean enabled = saplingSection.getBoolean((String)key, false);
                if (!enabled) continue;
                try {
                    Material m = Material.matchMaterial((String)((String)key).toUpperCase());
                    if (m == null) {
                        this.plugin.getLogger().warning("Unknown sapling/material key in config: " + (String)key);
                        continue;
                    }
                    String name = m.name();
                    if (name.endsWith("_SAPLING") || name.equals("MANGROVE_PROPAGULE")) {
                        this.saplings.add(m);
                        continue;
                    }
                    this.saplings.add(m);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().warning("Unknown sapling/material key in config: " + (String)key);
                }
            }
        } else {
            this.plugin.getLogger().warning("Config section 'saplings' missing; no saplings will be allowed.");
        }
        ConfigurationSection soilSection = cfg.getConfigurationSection("soils");
        if (soilSection != null) {
            for (String key : soilSection.getKeys(false)) {
                boolean enabled = soilSection.getBoolean(key, false);
                if (!enabled) continue;
                try {
                    Material m = Material.matchMaterial((String)key.toUpperCase());
                    if (m == null) {
                        this.plugin.getLogger().warning("Unknown soil material key in config: " + key);
                        continue;
                    }
                    this.validSoils.add(m);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().warning("Unknown soil material key in config: " + key);
                }
            }
        } else {
            this.plugin.getLogger().warning("Config section 'soils' missing; no soils will be valid.");
        }
        if (this.saplings.isEmpty() && this.validSoils.isEmpty()) {
            String[] defaultSaplings;
            String[] defaultSoils;
            this.plugin.getLogger().warning("No saplings and soils loaded; applying fallback defaults.");
            for (String n : defaultSoils = new String[]{"DIRT", "GRASS_BLOCK", "PODZOL", "COARSE_DIRT", "ROOTED_DIRT", "MOSS_BLOCK", "MUD"}) {
                Material m = Material.matchMaterial((String)n);
                if (m == null) continue;
                this.validSoils.add(m);
            }
            for (String n : defaultSaplings = new String[]{"OAK_SAPLING", "SPRUCE_SAPLING", "BIRCH_SAPLING", "JUNGLE_SAPLING", "ACACIA_SAPLING", "DARK_OAK_SAPLING", "CHERRY_SAPLING", "MANGROVE_PROPAGULE"}) {
                Material m = Material.matchMaterial((String)n);
                if (m == null) continue;
                this.saplings.add(m);
            }
        }
        if ((growthSection = cfg.getConfigurationSection("growth-light-override")) == null) {
            this.growthLightOverrideEnabled = true;
            this.growthMinimumLightLevel = 1;
        } else {
            this.growthLightOverrideEnabled = growthSection.getBoolean("enabled", true);
            int configuredLight = growthSection.getInt("minimum-level", 1);
            if (configuredLight < 0 || configuredLight > 15) {
                this.plugin.getLogger().warning("growth-light-override.minimum-level outside 0-15; falling back to vanilla requirement (10).");
                this.growthMinimumLightLevel = 10;
            } else {
                this.growthMinimumLightLevel = configuredLight;
            }
            long periodSeconds = Math.max(1L, growthSection.getLong("attempt-period-seconds", 5L));
            this.growthTaskPeriodTicks = periodSeconds * 20L;
            double configuredChance = growthSection.getDouble("attempt-chance", 0.15);
            if (configuredChance < 0.0 || configuredChance > 1.0) {
                this.plugin.getLogger().warning("growth-light-override.attempt-chance outside 0-1; falling back to default (0.15).");
                this.growthAttemptChance = 0.15;
            } else {
                this.growthAttemptChance = configuredChance;
            }
        }
        if (this.growthLightOverrideEnabled) {
            this.rebuildTrackedSaplings();
            this.restartGrowthTask();
        } else {
            this.trackedSaplings.clear();
            this.cancelGrowthTask();
        }
        if (logStats) {
            this.plugin.getLogger().info("Loaded soils: " + this.validSoils.size() + ", saplings: " + this.saplings.size() + ", require-water-above=" + this.requireWaterAbove + ", protect-underwater-saplings=" + this.protectSaplings + ", growth-override=" + this.growthLightOverrideEnabled + " (min=" + this.growthMinimumLightLevel + ", periodTicks=" + this.growthTaskPeriodTicks + ", chance=" + this.growthAttemptChance + "), log-detail=" + logDetail);
        }
        if (logDetail) {
            if (!this.validSoils.isEmpty()) {
                this.plugin.getLogger().info("Soils:");
                for (Material m : this.validSoils) {
                    this.plugin.getLogger().info(" - " + m.name());
                }
            }
            if (!this.saplings.isEmpty()) {
                this.plugin.getLogger().info("Saplings:");
                for (Material m : this.saplings) {
                    this.plugin.getLogger().info(" - " + m.name());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent event) {
        if (!this.protectSaplings) {
            return;
        }
        Block b = event.getBlock();
        if (!this.saplings.contains(b.getType())) {
            return;
        }
        Block soil = b.getRelative(BlockFace.DOWN);
        if (!this.validSoils.contains(soil.getType())) {
            return;
        }
        Block above = b.getRelative(BlockFace.UP);
        if (this.requireWaterAbove && above.getType() != Material.WATER) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlaceUnderwater(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material type = item.getType();
        if (!this.saplings.contains(type)) {
            return;
        }
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            return;
        }
        if (event.getBlockFace() != BlockFace.UP) {
            return;
        }
        Block placeBlock = clicked.getRelative(BlockFace.UP);
        if (this.requireWaterAbove && placeBlock.getType() != Material.WATER) {
            return;
        }
        if (!this.validSoils.contains(clicked.getType())) {
            return;
        }
        event.setCancelled(true);
        BlockData data = Bukkit.createBlockData((Material)type);
        if (data instanceof Sapling) {
            Sapling s = (Sapling)data;
            s.setStage(0);
            placeBlock.setBlockData((BlockData)s, false);
        } else {
            placeBlock.setType(type, false);
        }
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE) {
            int amount = item.getAmount();
            if (amount > 1) {
                item.setAmount(amount - 1);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
        }
        placeBlock.getWorld().playSound(placeBlock.getLocation(), Sound.BLOCK_GRASS_PLACE, 1.0f, 1.0f);
        this.addTrackedIfCandidate(placeBlock);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSaplingPlaced(BlockPlaceEvent event) {
        if (!this.saplings.contains(event.getBlockPlaced().getType())) {
            return;
        }
        this.addTrackedIfCandidate(event.getBlockPlaced());
    }

    @EventHandler(ignoreCancelled=true)
    public void onSaplingBreak(BlockBreakEvent event) {
        if (!this.saplings.contains(event.getBlock().getType())) {
            return;
        }
        this.removeTracked(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSaplingGrow(BlockGrowEvent event) {
        if (!this.saplings.contains(event.getBlock().getType())) {
            return;
        }
        this.removeTracked(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSaplingFade(BlockFadeEvent event) {
        if (!this.growthLightOverrideEnabled) {
            return;
        }
        Block block = event.getBlock();
        if (!this.saplings.contains(block.getType())) {
            return;
        }
        if (!this.isUnderwaterCandidate(block)) {
            this.trackedSaplings.remove(BlockCoordinate.of(block));
            return;
        }
        byte light = block.getLightLevel();
        if (light >= this.growthMinimumLightLevel) {
            event.setCancelled(true);
            this.addTrackedIfCandidate(block);
        } else {
            this.removeTracked(block);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.growthLightOverrideEnabled) {
            return;
        }
        this.scanChunkForSaplings(event.getChunk());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (this.trackedSaplings.isEmpty()) {
            return;
        }
        String worldName = event.getWorld().getName();
        int chunkX = event.getChunk().getX();
        int chunkZ = event.getChunk().getZ();
        this.trackedSaplings.removeIf(pos -> pos.world().equals(worldName) && pos.x() >> 4 == chunkX && pos.z() >> 4 == chunkZ);
    }

    public int getSaplingCount() {
        return this.saplings.size();
    }

    public int getSoilCount() {
        return this.validSoils.size();
    }

    public Set<Material> getSaplings() {
        return Collections.unmodifiableSet(this.saplings);
    }

    public Set<Material> getValidSoils() {
        return Collections.unmodifiableSet(this.validSoils);
    }

    private void addTrackedIfCandidate(Block block) {
        if (!this.growthLightOverrideEnabled) {
            return;
        }
        if (!this.shouldTrack(block)) {
            return;
        }
        this.trackedSaplings.add(BlockCoordinate.of(block));
    }

    private void removeTracked(Block block) {
        this.trackedSaplings.remove(BlockCoordinate.of(block));
    }

    private boolean shouldTrack(Block block) {
        if (!this.saplings.contains(block.getType())) {
            return false;
        }
        if (!this.hasWaterAbove(block)) {
            return false;
        }
        Block soil = block.getRelative(BlockFace.DOWN);
        return this.validSoils.contains(soil.getType());
    }

    private boolean isUnderwaterCandidate(Block block) {
        return this.shouldTrack(block);
    }

    private boolean hasWaterAbove(Block block) {
        Material above = block.getRelative(BlockFace.UP).getType();
        return above == Material.WATER || above == Material.BUBBLE_COLUMN;
    }

    private void rebuildTrackedSaplings() {
        this.trackedSaplings.clear();
        if (!this.growthLightOverrideEnabled || this.saplings.isEmpty()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                this.scanChunkForSaplings(chunk);
            }
        }
    }

    private void scanChunkForSaplings(Chunk chunk) {
        if (this.saplings.isEmpty()) {
            return;
        }
        int minY = chunk.getWorld().getMinHeight();
        int maxY = chunk.getWorld().getMaxHeight();
        for (int y = minY; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, y, z);
                    if (!this.shouldTrack(block)) continue;
                    this.trackedSaplings.add(BlockCoordinate.of(block));
                }
            }
        }
    }

    private void restartGrowthTask() {
        this.cancelGrowthTask();
        if (!this.growthLightOverrideEnabled) {
            return;
        }
        this.growthTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::tickTrackedSaplings, this.growthTaskPeriodTicks, this.growthTaskPeriodTicks);
    }

    private void cancelGrowthTask() {
        if (this.growthTask != null) {
            this.growthTask.cancel();
            this.growthTask = null;
        }
    }

    private void tickTrackedSaplings() {
        if (!this.growthLightOverrideEnabled) {
            return;
        }
        if (this.trackedSaplings.isEmpty()) {
            return;
        }
        Iterator<BlockCoordinate> iterator = this.trackedSaplings.iterator();
        int processed = 0;
        while (iterator.hasNext() && processed < 64) {
            BlockCoordinate coordinate = iterator.next();
            Block block = this.getLoadedBlock(coordinate);
            if (block == null) {
                ++processed;
                continue;
            }
            if (!this.saplings.contains(block.getType())) {
                iterator.remove();
                ++processed;
                continue;
            }
            if (!this.isUnderwaterCandidate(block)) {
                iterator.remove();
                ++processed;
                continue;
            }
            if (block.getLightLevel() < this.growthMinimumLightLevel) {
                ++processed;
                continue;
            }
            if (ThreadLocalRandom.current().nextDouble() > this.growthAttemptChance) {
                ++processed;
                continue;
            }
            if (this.attemptSaplingGrowth(block)) {
                iterator.remove();
            }
            ++processed;
        }
    }

    private Block getLoadedBlock(BlockCoordinate coordinate) {
        int chunkZ;
        World world = Bukkit.getWorld((String)coordinate.world());
        if (world == null) {
            return null;
        }
        int chunkX = coordinate.x() >> 4;
        if (!world.isChunkLoaded(chunkX, chunkZ = coordinate.z() >> 4)) {
            return null;
        }
        return world.getBlockAt(coordinate.x(), coordinate.y(), coordinate.z());
    }

    private boolean attemptSaplingGrowth(Block block) {
        Material before = block.getType();
        boolean applied = block.applyBoneMeal(BlockFace.UP);
        if (!applied) {
            return false;
        }
        return !this.saplings.contains(before) || !this.saplings.contains(block.getType());
    }

    private record BlockCoordinate(String world, int x, int y, int z) {
        static BlockCoordinate of(Block block) {
            return new BlockCoordinate(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
        }
    }
}

