/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer;

import com.iamkaf.amber.api.event.v1.events.common.client.ClientTickEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.HudEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.InputEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.RenderEvents;
import com.iamkaf.amber.api.keymapping.KeybindHelper;
import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.config.KeyMode;
import com.iamkaf.liteminer.config.LiteminerClientConfig;
import com.iamkaf.liteminer.networking.C2SVeinmineKeybindChange;
import com.iamkaf.liteminer.networking.LiteminerNetwork;
import com.iamkaf.liteminer.rendering.BlockHighlightRenderer;
import com.iamkaf.liteminer.rendering.HUD;
import com.iamkaf.liteminer.shapes.Cycler;
import com.iamkaf.liteminer.shapes.Walker;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LiteminerClient {
    public static final int PACKET_DELAY = 125;
    public static final KeyMapping.Category KEY_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"liteminer", (String)"liteminer"));
    public static final KeyMapping KEY_MAPPING = new KeyMapping("key.liteminer.veinmine", InputConstants.Type.KEYSYM, 96, KEY_CATEGORY);
    public static final LiteminerClientConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public static HashSet<BlockPos> selectedBlocks;
    public static Cycler<Walker> shapes;
    private static boolean currentState;
    private static long lastChange;

    public static void init() {
        KeybindHelper.register((KeyMapping)KEY_MAPPING);
        ClientTickEvents.END_CLIENT_TICK.register(LiteminerClient::onPostTick);
        HudEvents.RENDER_HUD.register(HUD::onRenderHUD);
        InputEvents.MOUSE_SCROLL_PRE.register(HUD::onMouseScroll);
        RenderEvents.BLOCK_OUTLINE_RENDER.register(BlockHighlightRenderer::renderLiteminerHighlight);
    }

    public static void onPostTick() {
        if (System.currentTimeMillis() - LiteminerClient.getLastChange() < 125L) {
            return;
        }
        switch ((KeyMode)((Object)LiteminerClient.CONFIG.keyMode.get())) {
            case HOLD: {
                boolean newState = KEY_MAPPING.isDown();
                if (newState == LiteminerClient.isVeinMining()) {
                    return;
                }
                LiteminerNetwork.sendToServer(new C2SVeinmineKeybindChange(newState, shapes.getCurrentIndex()));
                currentState = newState;
                break;
            }
            case TOGGLE: {
                if (!KEY_MAPPING.consumeClick()) break;
                boolean newState = !LiteminerClient.isVeinMining();
                LiteminerNetwork.sendToServer(new C2SVeinmineKeybindChange(newState, shapes.getCurrentIndex()));
                currentState = newState;
            }
        }
    }

    public static boolean isVeinMining() {
        return currentState;
    }

    public static long getLastChange() {
        return lastChange;
    }

    public static void setLastChange(long lastChange) {
        LiteminerClient.lastChange = lastChange;
    }

    public static boolean isTargetingABlock() {
        HitResult result = Minecraft.getInstance().hitResult;
        return result != null && result.getType() == HitResult.Type.BLOCK;
    }

    static {
        selectedBlocks = HashSet.newHashSet(0);
        shapes = new Cycler<Walker>(Liteminer.WALKERS);
        currentState = false;
        lastChange = System.currentTimeMillis();
        Pair pair = new ModConfigSpec.Builder().configure(LiteminerClientConfig::new);
        CONFIG = (LiteminerClientConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

