/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.event;

import com.iamkaf.amber.api.event.v1.events.common.BlockEvents;
import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.LiteminerPlayerState;
import com.iamkaf.liteminer.shapes.Walker;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class OnBlockInteraction {
    public static void init() {
        BlockEvents.BLOCK_INTERACT.register(OnBlockInteraction::onBlockInteracted);
    }

    private static InteractionResult onBlockInteracted(Player player, Level level, InteractionHand hand, BlockHitResult blockHitResult) {
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (hand.equals((Object)InteractionHand.OFF_HAND) && OnBlockInteraction.isTieredItem(player.getMainHandItem().getItem())) {
            return InteractionResult.PASS;
        }
        ItemStack tool = player.getItemInHand(hand);
        Item item = tool.getItem();
        if (!OnBlockInteraction.isTieredItem(item)) {
            return InteractionResult.PASS;
        }
        LiteminerPlayerState playerState = Liteminer.instance.getPlayerState((ServerPlayer)player);
        if (!playerState.getKeymappingState()) {
            return InteractionResult.PASS;
        }
        if (tool.isDamageableItem() && tool.getMaxDamage() - tool.getDamageValue() == 1) {
            return InteractionResult.PASS;
        }
        Walker walker = Liteminer.WALKERS.get(playerState.getShape());
        List<BlockPos> blocks = walker.walk(level, player, blockPos).stream().sorted(Comparator.comparingInt(p -> p.distManhattan((Vec3i)blockPos))).toList();
        for (BlockPos block : blocks) {
            if (block.equals((Object)blockPos)) continue;
            if (!tool.isEmpty() && tool.isDamageableItem()) {
                boolean itemIsAboutToBreak = tool.getMaxDamage() - tool.getDamageValue() <= 2;
                boolean preventFromBreaking = (Boolean)Liteminer.CONFIG.preventToolBreaking.get();
                if (itemIsAboutToBreak && preventFromBreaking) break;
            }
            item.useOn(new UseOnContext(player, hand, new BlockHitResult(block.getBottomCenter(), direction, block, false)));
            boolean exhaustionEnabled = (Boolean)Liteminer.CONFIG.foodExhaustionEnabled.get();
            float exhaustion = ((Double)Liteminer.CONFIG.foodExhaustion.get()).floatValue();
            if (!exhaustionEnabled || !(exhaustion > 0.0f)) continue;
            player.causeFoodExhaustion(exhaustion);
        }
        return InteractionResult.PASS;
    }

    private static boolean isTieredItem(Item item) {
        Tool tool = (Tool)item.getDefaultInstance().get(DataComponents.TOOL);
        return tool != null;
    }
}

